
import os
import string
import sys

#---------------------------------------------------------------------
#
# This script should be installed within the loginfo file of CVS
# using the following line :
#
# ...
#.cmtcvsinfos $CVSROOT/CVSROOT/cmt_buildcvsinfos.sh
# ...
#
# and is used whenever one tries to import a module named .cmtcvsinfos/<module>
#
#---------------------------------------------------------------------

#---------------------------------------------------------------------
def CVSROOT () :
    e = os.environ ['CVSROOT']
    pos = e.find (':')
    if pos == 0 :
        e = e[1:]
        pos = e.find (':')
        e = e[pos+1:]

    return (e)
#---------------------------------------------------------------------
    
#------------------------------------------------------------
def remove_dir (d):
    if not os.path.exists (d) : return
    
    for f in os.listdir(d) :
        name = d + '/' + f
        if os.path.isdir (name) : remove_dir (name)
        else :
            os.chmod (name, 0777)
            os.remove (name)

    os.rmdir (d)
#------------------------------------------------------------

#------------------------------------------------------------
def check_head (head, version) :
    hlist = head.split ('.')
    vlist = version.split ('.')
    i = 0
    for h in hlist :
        if h != vlist[i] : return 0
        i = i + 1
        
    return 1
#------------------------------------------------------------

#------------------------------------------------------------
#    test :  v1 newer then v2
#
def check_newer (v1, v2) :
    list1 = v1.split ('.')
    if len(list1) == 0 : return 0
    
    list2 = v2.split ('.')
    i = 0
    for h in list1 :
        if i > len(list2) : return 1
        if h > list2[i] : return 1
        i = i + 1
        
    return 0
#------------------------------------------------------------

#------------------------------------------------------------
def get_tags (module_file) :
    if not os.path.isdir (module_file) : return ('')
    
    tags = ''
    test_file = ''
    if os.path.exists (module_file + '/cmt/requirements,v') :
        test_file = module_file + '/cmt/requirements,v'
    elif os.path.exists (module_file + '/mgr/requirements,v') :
        test_file = module_file + '/mgr/requirements,v'
    else :
        for f in os.listdir (module_file) :
            if f[-2:] == ',v' :
                test_file = module_file + '/' + f
                break;

    if test_file == '' : return ('')

    started = 0
    finished = 0
    top = ''
    toptag = ''
    cvstags = ''
    
    f = open (test_file, 'r')
    while 1 :
        line = f.readline ()
        line = line [:-1]
        if len (line) == 0 : break

        if not started :
            if line.find ('symbols') >= 0 :
                started = 1
                finished = 0
                pos = line.find ('symbols')
                line = line[pos+7:]
                
        if not finished :
            if line.find ('locks;') >= 0 :
                finished = 1
                break
            else :
                line = line.strip ()
                n = line.count ('.')
                if n == 1 or n == 3 or n == 5 :
                    pos = line.find (':')
                    if pos >= 0 :
                        v = line[pos+1:]
                        tag = line[:pos]
                        if check_newer (v, top) == 1 : top = v
                        tags += tag + ' '
                        cvstags += v + ' '
    
    taglist = tags.split ()
    ts = cvstags.split ()
    tags = ''
    i = 0
    for t in ts :
        tags += taglist[i]
        if top == t : tags += '(t)'
        tags += ' '
        i = i + 1

    f.close ()

    return (tags)
#------------------------------------------------------------

#------------------------------------------------------------
def get_branches (module_file) :
    if not os.path.isdir (module_file) : return ('')
    branches = ''
    for branch in os.listdir (module_file) :
        if branch == 'Attic' : continue
        branch_file = module_file + '/' + branch
        if os.path.isdir (branch_file) :
            if not os.path.exists (branch_file + '/cmt/requirements,v') :
                if not os.path.exists (branch_file + '/mgr/requirements,v') :
                    branches += branch + ' '

    return (branches)
#------------------------------------------------------------

#------------------------------------------------------------
def get_subpackages (module_file) :
    if not os.path.isdir (module_file) : return ('')
    subpackages = ''
    for branch in os.listdir (module_file) :
        if branch == 'Attic' : continue
        branch_file = module_file + '/' + branch
        if os.path.isdir (branch_file) :
            if os.path.exists (branch_file + '/cmt/requirements,v') :
                subpackages += branch + ' '
            elif os.path.exists (branch_file + '/mgr/requirements,v') :
                subpackages += branch + ' '
                
    return (subpackages)
#------------------------------------------------------------

if os.path.exists (CVSROOT() + '/.cmtcvsinfos') :
    remove_dir (CVSROOT() + '/.cmtcvsinfos')

a = raw_input ()

root = CVSROOT ()

print ('a=' + a)

pos = a.find ('.cmtcvsinfos/')

if pos == -1 :
    print ('error=syntax error')
    sys.exit (1)

module = a[pos+len('.cmtcvsinfos/'):]

print ('module=[' + module + ']')

errormsg = ''

module_file = CVSROOT () + '/' + module

print ('module_file=[' + module_file + ']')

if not os.path.isdir (module_file) :
    errormsg = '### Module ' + module + ' not found.'
    
tags = get_tags (module_file)
branches = get_branches (module_file)
subpackages = get_subpackages (module_file)

if errormsg != '' :
    print ('error=' + errormsg)

taglist = tags.split ()
tags_top = ''
tags = ''
for t in taglist :
    pos = t.find ('(t)')
    if pos >= 0 :
        tags_top += t[:pos] + ' '
    else :
        tags += t + ' '

print ('tags_top=' + tags_top)
print ('tags=' + tags)
print ('branches=' + branches)
print ('subpackages=' + subpackages)

sys.exit (1)




