//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "cmt_branch.h"
#include "cmt_database.h"

/*----------------------------------------------------------*/
/*                                                          */
/*  Operations on Branches                                  */
/*                                                          */
/*----------------------------------------------------------*/

/*----------------------------------------------------------*/
void Branch::action (const CmtSystem::cmt_string_vector& words)
/*----------------------------------------------------------*/
{
  for (int i = 1; i < words.size (); i++)
    {
      const cmt_string& name = words[i];
      if (name == "") return;

      add (name);
    }
}

/*----------------------------------------------------------*/
Branch* Branch::find (const cmt_string& name)
/*----------------------------------------------------------*/
{
  static BranchVector& Branches = branches ();

  int branch_index;

  if (Branches.size () == 0) return (0);

  for (branch_index = 0;
       branch_index < Branches.size ();
       branch_index++)
    {
      Branch& branch = Branches[branch_index];

      if (branch.name () == name)
        {
          return (&branch);
        }
    }

  return (0);
}

/*----------------------------------------------------------*/
void Branch::add (const cmt_string& name)
/*----------------------------------------------------------*/
{
  static BranchVector& Branches = branches ();

  {
    Branch* branch;

    branch = find (name);
    if (branch != 0) return;
  }

  Branch& branch = Branches.add ();

  branch.m_name = name;
}

/*----------------------------------------------------------*/
void Branch::print_all (PrintMode mode)
/*----------------------------------------------------------*/
{
  static BranchVector& Branches = branches ();

  int number;

  for (number = 0; number < Branches.size (); number++)
    {
      if (number > 0) cout << " ";
      Branches[number].print (mode);
    }
  if (number > 0) cout << endl;
}

/*----------------------------------------------------------*/
void Branch::clear_all ()
/*----------------------------------------------------------*/
{
  static BranchVector& Branches = branches ();

  int number;

  for (number = 0; number < Branches.size (); number++)
    {
      Branch& b = Branches[number];

      b.m_name = "";
    }

  Branches.clear ();
}

/*----------------------------------------------------------*/
Branch::BranchVector& Branch::branches ()
/*----------------------------------------------------------*/
{
  static Database& db = Database::instance ();
  static BranchVector& Branches = db.branches ();

  return (Branches);
}

/*----------------------------------------------------------*/
Branch::Branch ()
/*----------------------------------------------------------*/
{
}

/*----------------------------------------------------------*/
Branch::~Branch ()
/*----------------------------------------------------------*/
{
}

/*----------------------------------------------------------*/
const cmt_string& Branch::name () const
/*----------------------------------------------------------*/
{
  return (m_name);
}

/*----------------------------------------------------------*/
void Branch::print (PrintMode mode) const
/*----------------------------------------------------------*/
{
  cout << m_name;
}

