//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#include <stdio.h>

typedef void (*Procedure) ();

#ifdef WIN32
#include <windows.h>

Procedure get_proc (const char* name)
{
  void* f = ::LoadLibrary ("..\\Win32Debug\\C.dll");

  if (f == 0)
    {
      f = ::LoadLibrary ("..\\VisualC\\C.dll");
    }

  if (f == 0)
    {
      printf ("Cannot load the library\n");
      exit (0);
    }

  Procedure p;

  p = (Procedure)::GetProcAddress ((HMODULE) f, name);
  if (p == 0)
    {
      char* s = new char[strlen(name) + 2];
      s[0] = '_';
      strcpy (s+1, name);
      p = (Procedure)::GetProcAddress((HMODULE) f, s);
    } 

  if (p == 0)
    {
      printf ("Cannot get the module %s\n", name);
      exit (0);
    }

  return (p);
}
#else
extern "C" {
void C1 ();
void C2 ();
void C3 ();
}
#endif

int main ()
{
  printf ("demoC\n");

  Procedure c = 0;

#ifdef WIN32
  c = get_proc ("C1");
  c ();
  c = get_proc ("C2");
  c ();
  c = get_proc ("C3");
  c ();
#else
  C1 ();
  C2 ();
  C3 ();
#endif

  return (0);
}



