
#set -x
#set -v
#echo $*

#--------------------------------------------------
build_deps ()
#--------------------------------------------------
#  Build the dependency line.
#
#  Globals :
#
#    includes         list of -I<path> preprocessor options
#    format_filter    sed commands for cleaning up the cpp output
#    include_filter   sed commands for formatting include statements
#
#  Inputs :
#
#    file       Source file to apply
#
#  Output :
#
#    $(src)source $(inc)dep1 ...
#
#--------------------------------------------------
{
#
#  $1 = source file
#

  if test -d ../src ; then
    srcdir=../src
  else
    srcdir=./
  fi

  file=$1
  shift

  # echo "makedepend ${includes} ${srcdir}/${file}" >x$$

  touch t$$
  eval makedepend ${includes} ${srcdir}/${file} -ft$$

  line=`cat t$$ | egrep -v '^#' | sed -e "$format_filter" -e "$include_filter"`

  /bin/rm -f t$$*

  line=`echo '$(src)'${file}; echo ${line}`

  line=`echo ${line} | sed 's#$(inc)#$(src)#'`

  echo $line
}

#--------------------------------------------------
genmake_package ()
#--------------------------------------------------
{

  if test -d ../src ; then
    srcdir=../src
  else
    srcdir=./
  fi

  if test -d ../mgr ; then
    mgrdir=../mgr/
  else
    mgrdir=`pwd`/
  fi

  if test -d ../include ; then
    incdir=../include
  else
    if test -d ../src ; then
      incdir=../src
    else
      incdir=./
    fi
  fi

  if test "$is_executable" = 1 ; then
    title='Executable'
  else
    title='Package'
  fi

  #---- Define output file. -----------------------------------------

  package=$1
  shift

  if test "$#" = 0 ; then
    sources=`(cd ../src; ls ${PACKTARGET}*.c)`
  else
    sources="$*"
  fi

  echo $title $PACKTARGET

  #---- Prepare the use context. ------------------------------------

  uses=`${CMTROOT}/mgr/cmt includes`

  includes="-I${incdir} ${uses} ${PACKINCLUDES}"

  # echo "includes = [" ${includes} "]"

  #  Remove trailing back-slashes
  #  Remove target
  #  Substitute ../src/ and ../include/ by $(inc)

  format_filter='s#\\##g
s#[^:]*:##
s#/usr/local/[^ ]*[ ]##g
s#/usr/local/.*$##g
s#/usr/include/[^ ]*[ ]##g
s#/usr/include/.*$##g
s#\.\./src/#$(inc)#g
s#/src/#/OS9/#g'

  # Substitute all "<path>/<package>/<version>/"
  # by "$(<PACKAGE>ROOT)/"

  include_filter=`${CMTROOT}/mgr/cmt filter_includes -quiet | sed 's#//#/#g'`

  #
  # Other initializations.
  #

  src='$(src)'
  inc='$(inc)'
  bin='$(bin)'
  rels='$(rels)'
  mgr='$(mgr)'

  if test "$is_library" = 1 ; then
    lib='$(lib)lib'${PACKTARGET}'.l'
    libstamp='$('${PACKTARGET}'stamp)'
    shlibstamp='$('${PACKTARGET}'shstamp)'
  else
    linkopts='$('${PACKTARGET}'linkopts)'
    stamps='$('${PACKTARGET}'stamps)'
  fi

  unset ccs
  unset CCs
  unset yaccs
  unset lexs
  unset objs
  unset protos
  unset protonames
  unset protostamps
  unset cyaccs
  unset clexs
  unset os9sources
  unset linkmacro
  unset subdir

  #
  # Scan the sources.
  #
  
  for file in $sources ; do
    echo $file | grep '^-s='
    if test "$?" = "0" ; then
      subdir=`echo $file | sed -e 's#^-s=##' -e 's#[/]*$#/#'`
    else
      suffix=`echo $file | sed 's/^.*\.//'`
      name=`echo $file | sed 's/\..*//'`
      oname="$name"
      
      if test "$linkmacro" = "" ; then
	if test "$suffix" = "f" ; then
	  linkmacro='$(flink)'
	elif test "$suffix" = "F" ; then
	  linkmacro='$(flink)'
	elif test "$suffix" = "c" ; then
	  linkmacro='$(clink)'
	elif test "$suffix" = "C" ; then
	  linkmacro='$(cpplink)'
	elif test "$suffix" = "cc" ; then
	  linkmacro='$(cpplink)'
	elif test "$suffix" = "cxx" ; then
	  linkmacro='$(cpplink)'
	else
	  linkmacro='none'
	fi
      fi
      
      if test "$suffix" = "f" ; then
	fs="$fs ${subdir}$file"
      elif test "$suffix" = "F" ; then
	fs="$fs ${subdir}$file"
      elif test "$suffix" = "c" ; then
	ccs="$ccs ${subdir}$file"
      elif test "$suffix" = "C" ; then
	CCs="$CCs ${subdir}$file"
      elif test "$suffix" = "cc" ; then
	CCs="$CCs ${subdir}$file"
      elif test "$suffix" = "cxx" ; then
	CCs="$CCs ${subdir}$file"
      elif test "$suffix" = "y" ; then
	yaccs="$yaccs ${subdir}$file"
	name=`echo $name | sed 's/Parse$//'`
	ccs="$ccs ${subdir}${name}Parse.c"
	oname="${name}Parse"
      elif test "$suffix" = "l" ; then
	lexs="$lexs ${subdir}$file"
	name=`echo $name | sed 's/Lex$//'`
	ccs="$ccs ${subdir}${name}Lex.c"
	oname="${name}Lex"
      fi
    
      obj="${rels}${oname}.r"
      
      objs="$objs $obj"
    fi

  done

  #-------------------------------------------
  #
  # Start the output.
  #
  #-------------------------------------------

  d=`date`

  cat <<END >$output

#====================================
#  $title $PACKTARGET
#
#   Generated $d  by $USER
#
#====================================
  
END

  pobjs='$('${PACKTARGET}'OBJS)'

  if test "$is_library" = 1 ; then

    cat <<END >>${output}

${PACKTARGET}OBJS = ${objs}

${lib}: ${pobjs}
 libgen -c -o=${lib} ${pobjs}
 @echo ${PACKTARGET} : library ok

END

  else
    
    cat <<END >>${output}

${PACKTARGET}OBJS = ${objs}

\$(bin)${PACKTARGET}: ${pobjs}
 cc \$(LINKFLAGS) -olM=8 \$(CFLAGS) -fd=\$@ \$?

END

  fi

  if test ! "$ccs" = "" ; then                           # C targets
    for file in $ccs ; do
      if test -f ${srcdir}/${file} ; then
	echo Source file $file
	
	line=`build_deps $file`

	if test "$line" != "" ; then
	  source=`echo $line | sed 's/[ ].*//'`
	  suffix=`echo ${file} | sed 's/^.*\.//'`
	  target=`basename $source ".${suffix}" | sed 's#$(src)##'`

	  cat <<END >>$output

\$(rels)${target}.r : ${line}
 cc \$(CFLAGS) -e=as -fd=\$@ ${src}\$*.c

END

	fi

	cat <<END >>$output

END

      else
	echo "Warning : cannot build dependancies for file $file (not found)"
      fi
    done
  fi

  cat <<END >>$output

END

}

#--------------------------------------------------
usage ()
#--------------------------------------------------
{
  echo "Usage :"
  echo "> genmakeos9.sh <Package> [ options ] <source files> "
  echo "     options : -I <include-path>"
  echo "               -L <Library>"
  echo "               -E <Executable>"
}

#--------------------------------------------------
#main ()
#--------------------------------------------------

argcount=$# #

if test $argcount = 0 ; then
  usage
  exit 0
fi

package=$1
shift

c=`echo "$package" | grep '^[-]'`

if test "$c" = "$package" ; then
  usage
  exit 0
fi

unset PACKINCLUDES
unset is_executable
unset PACKOS9
PACKTARGET=$package

while test "$#" -gt 0 ; do

  command=$1
  c=`echo "$command" | grep '^[-]'`

  if test "$c" = "$command" ; then
    #
    # Here we have a command (starting with -)
    #
    shift
  else
    #
    # The first non-command argument terminates the parsing.
    #
    break
  fi

  if test "$command" = "-I" ; then
    #
    #   The include path is defined in the next argument.
    #
    include=$1
    shift

    PACKINCLUDES="$PACKINCLUDES -I$include"

    unset include

  elif test "$command" = "-L" ; then
    is_library=1
    is_executable=0
    PACKTARGET=$1
    shift
  elif test "$command" = "-E" ; then
    is_library=0
    is_executable=1
    PACKTARGET=$1
    shift
  elif test "$command" = "-OS9" ; then
    PACKOS9=1
  else
    echo "Usage :"
    echo "> genmakeos9.sh <Package> [ options ] <source files> "
    echo "     options : -I <include-path>"
    echo "               -L <Library>"
    echo "               -E <Executable>"
    exit 0
  fi
done

#
#  To get access to cpp
#

  system=`uname`
  if test "$system" = "HP-UX" ; then
    v=`uname -r | cut -d. -f2`
    if test "$v" = 10 ; then
      PATH=$PATH:/usr/ccs/lbin
    else
      PATH=$PATH:/lib
    fi
    unset v
  elif test "$system" = "AIX" ; then
    PATH=$PATH:/usr/ccs/lib
  fi

#---- Define old and output files. --------------------------------

  if test -d ../mgr ; then
    mgrdir=../mgr/
  else
    mgrdir=`pwd`/
  fi

  old=${mgrdir}${PACKTARGET}.os9make
  backup=${old}sav
  output=${old}new
  
  genmake_package $package $*

#---- Complete the operation --------------------------------------

  if test -r $old ; then
    mv $old $backup
  fi

  mv $output $old



