//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_group_h__
#define __cmt_group_h__

#include "cmt_parser.h"
#include "cmt_system.h"

class Group
{
public:

  typedef cmt_vector<Group> GroupVector;

  static Group* find (const cmt_string& name);
  static Group* add (const cmt_string& name);

  static GroupVector& groups ();
  static void clear_all ();
  static void show_all ();

public:

  Group ();
  Group (const cmt_string& name);

  const cmt_string& name () const;
  void set (const cmt_string& new_name);
  void clear ();

  Group& operator = (const Group& other);
  bool operator == (const cmt_string& name) const;
  bool operator != (const cmt_string& name) const;

private:
  cmt_string m_name;
  cmt_string m_macro;
};

#endif
