//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_log_h__
#define __cmt_log_h__

#include "cmt_string.h"

class CmtLogEnd
{
public:
};

class CmtLogDummy
{
public:
};

class CmtLog
{
public:
  CmtLog ();

  static CmtLogEnd& end ();
  CmtLog& operator << (const cmt_string& s);
  CmtLog& operator << (const char* c);
  CmtLog& operator << (int i);
  CmtLog& operator << (double d);
  CmtLog& operator << (void* p);
  CmtLog& operator << (CmtLogEnd& end);
  CmtLog& operator << (CmtLogDummy& dummy);

private:
  bool check ();
};

#define Log static CmtLog log_instance
#define log_endl CmtLog::end ()
#define log      if (Cmt::get_debug ()) log_instance << "#CMT> (" << __FILE__ << "-" << __LINE__ << ") "
#define log_cont if (Cmt::get_debug ()) log_instance

#endif
