#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

function cmt_macros { reply=(`cmt -quiet show macro_names`)}; \
   function cmt_actions { reply=(`cmt -quiet show action_names`)}; \
   function cmt_sets { reply=(`cmt -quiet show set_names`)}; \
   function cmt_constituents { reply=(`cmt -quiet show constituent_names`) }; \
   function cmt_fragments { reply=(`cmt -quiet show fragments | sed 's#.*/fragments/##'`)}; \
   function cmt_default_path { d=`dirname ${CMTROOT}`; reply=(`dirname ${d}`) }; \
   function cmt_patterns { reply=(`cmt -quiet show pattern_names`) }; \
   compctl -k '(broadcast,build,check,check_files,checkout,co,cleanup,config,create,create_project,expand,filter,help,lock,remove,run,setup,show,system,unlock,version,cvstags,cvsbranches,cvssubpackages,cvssubprojects)' -x \
   'c[-1,broadcast]' -k '(-begin=,-select=,-exclude=,-local,-global,-depth=)' - \
   's[build],c[-1,build]' -k '(CMT_pacman, constituent_makefile,constituents_makefile,dependencies,library_links,make_setup,msdev,os9_makefile,prototype,readme,tag_makefile,temporary_name,triggers,win_makefile)' - \
   'w[1,build] c[-1,constituent_makefile]' -K cmt_constituents - \
   'w[1,build] c[-1,triggers]' -K cmt_constituents - \
   'c[-1,check]' -k '(configuration,files,version)' - \
   'w[1,create] p[2]' -X '> give package name' - \
   'w[1,create] p[3]' -X '> give version tag' - \
   'w[1,create] p[4]' -X '> give a path if not created from current path' - \
   's[expand],c[-1,expand]' -k '(model)' - \
   'w[1,remove] p[2]' -X '> library_links or give package name' - \
   'w[1,remove] p[3]' -X '> give version tag' - \
   'w[1,remove] p[4]' -X '> give a path if not located from the current path ' - \
   's[show],c[-1,show]' -k '(action,action_names,action_value,actions,all_tags,applied_patterns,author,branches,clients,cmtpath_patterns,constituent,constituent_names,constituents,cycles,fragment,fragments,groups,include_dirs,language,languages,macro,macro_names,macro_value,macros,manager,packages,path,pattern,patterns,projects,pwd,set,set_names,set_value,sets,strategies,tags,use_paths,uses,versions)' - \
   'w[1,show] c[-1,constituent]' -K cmt_constituents - \
   'w[1,show] c[-1,fragment]' -K cmt_fragments - \
   'w[1,show] c[-1,action]' -K cmt_actions - \
   'w[1,show] c[-1,action_value]' -K cmt_actions - \
   'w[1,show] c[-1,macro]' -K cmt_macros - \
   'w[1,show] c[-1,macro_value]' -K cmt_macros - \
   'w[1,show] c[-1,pattern]' -K cmt_patterns - \
   'w[1,show] c[-1,set]' -K cmt_sets - \
   'w[1,show] c[-1,set_value]' -K cmt_sets - \
   'c[-1,co]' -k '(-l,-R,-r,-d,-o,-requirements)' - \
   'c[-1,checkout]' -k '(-l,-R,-r,-d,-o,-requirements)' - \
   'c[-1,-r]' -X 'give a CVS tag' - \
   'c[-1,-d]' -X 'give a directory name' - \
   'c[-1,-o]' -X 'give an offset in the CVS repository' - \
   'c[-1,-requirements]' -f - \
   'c[-1,co]' -X 'give package name' \
   --  cmt.exe



