//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_model_h__
#define __cmt_model_h__

#include "cmt_system.h"

class CmtModel
{
public:
  static void expand (const cmt_string& input_text);
  static void strict_expand (const cmt_string& input_text);
  static void test_regexp (const cmt_string& pattern, const cmt_string& input_text);

private:
  static void filter (cmt_string& text);
  static void display (cmt_string& text);
  static void expand (const CmtSystem::cmt_string_vector& arguments);
};

#endif
