//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_constituent_h__
#define __cmt_constituent_h__

#include "cmt_parser.h"
#include "cmt_system.h"
#include "cmt_fragment.h"
#include "cmt_group.h"

class Constituent
{
public:
  typedef cmt_vector<Constituent> ConstituentVector;
  static void action (ConstituentType type,
                      const CmtSystem::cmt_string_vector& words);
  static Constituent* find (const cmt_string& name);
  static Constituent* add (ConstituentType type,
                           const cmt_string& name,
                           const cmt_string& generator);
  static Constituent* add_for_action (const cmt_string& name);
  static void show (const cmt_string& name);
  static void parse_all ();
  static void show_all ();
  static void show_names ();
  static void build_all_makefiles (bool simulation);
  static void build_all_msdev_files (bool simulation);
  static void build_all_vsnet_files (bool simulation); 
  static void clear_all ();
  static ConstituentVector& constituents ();

public:
  Constituent ();
  ~Constituent ();
  void parse ();

  virtual void clear ();
  virtual void build_makefile (bool simulation) const;
  virtual void build_msdev_file (bool simulation) const;
  virtual void build_vsnet_file (bool simulation) const;
  virtual void show () const;

  cmt_string name;
  cmt_string generator;
  ConstituentType type;
  Group* group;
  cmt_string suffix;
  CmtSystem::cmt_string_vector modules;
  bool need_OS9;
  bool windows;
  bool no_static;
  bool no_share;
  bool need_prototypes;
  bool need_check;
  bool build_triggers;
  bool has_target_tag;
  CmtSystem::cmt_string_vector excludes;
  cmt_vector<cmt_regexp> exclude_exprs;

  CmtSystem::cmt_string_vector selects;
  cmt_vector<cmt_regexp> select_exprs;

  CmtSystem::cmt_string_vector includes;
  CmtSystem::cmt_string_vector imports;
  Variable::VariableVector variables;

private:
  CmtSystem::cmt_string_vector parameters;

};

#endif
