
@echo off

rem
rem Test de -no_auto_import
rem

rem
rem  4 packages A, B, C, D
rem

set scroot=%CMTROOT%\demo\scenario1

set CMTPATH=%scroot%

rmdir /Q /S %scroot%
mkdir %scroot%
cmt create A v1 %scroot%
cmt create B v1 %scroot%
cmt create C v1 %scroot%
cmt create D v1 %scroot%

cd %scroot%

echo #ifndef __$(package)_h__       > template.h
echo #define __$(package)_h__      >> template.h
echo class $(package)              >> template.h
echo {                             >> template.h
echo   public:                     >> template.h
echo     $(package) ();            >> template.h
echo     void f ();                >> template.h
echo };                            >> template.h
echo #endif                        >> template.h

echo #include "$(package).h"        > template.cxx
echo #include "stdio.h"            >> template.cxx
echo $(package)::$(package) ()     >> template.cxx
echo {                             >> template.cxx
echo }                             >> template.cxx
echo void $(package)::f ()         >> template.cxx
echo {                             >> template.cxx
echo   printf ("$(package)::f\n"); >> template.cxx
echo }                             >> template.cxx

echo package $(package) >requirements
echo macro $(package)_linkopts "%scroot%\$(package)\v1\%CMTCONFIG%\$(package).lib" >>requirements
echo library $(package) $(package).cxx >>requirements
echo path_append PATH "%scroot%\$(package)\v1\%CMTCONFIG%" >>requirements

cd %scroot%\B\v1\cmt
cmt filter %scroot%\template.h ..\src\B.h
cmt filter %scroot%\template.cxx ..\src\B.cxx
cmt filter %scroot%\requirements requirements
nmake /f nmake

cd %scroot%\C\v1\cmt
cmt filter %scroot%\template.h ..\src\C.h
cmt filter %scroot%\template.cxx ..\src\C.cxx
cmt filter %scroot%\requirements requirements
nmake /f nmake

cd %scroot%\D\v1\cmt
cmt filter %scroot%\template.h ..\src\D.h
cmt filter %scroot%\template.cxx ..\src\D.cxx
cmt filter %scroot%\requirements requirements
nmake /f nmake

cd %scroot%\A\v1\cmt

echo package A                   > requirements
echo use B v1                   >> requirements
echo use C v1 -no_auto_imports  >> requirements
echo use D v1 -no_auto_imports  >> requirements
echo application b -check b.cxx >> requirements
echo application c -check -import=C c.cxx >> requirements
echo application d -check -import=C -import=D d.cxx >> requirements

echo #include "B.h"              > ..\src\b.cxx
echo int main ()                >> ..\src\b.cxx
echo {                          >> ..\src\b.cxx
echo   B b;                     >> ..\src\b.cxx
echo   b.f ();                  >> ..\src\b.cxx
echo   return (0);              >> ..\src\b.cxx
echo }                          >> ..\src\b.cxx

echo #include "B.h"              > ..\src\c.cxx
echo #include "C.h"             >> ..\src\c.cxx
echo int main ()                >> ..\src\c.cxx
echo {                          >> ..\src\c.cxx
echo   B b;                     >> ..\src\c.cxx
echo   b.f ();                  >> ..\src\c.cxx
echo   C c;                     >> ..\src\c.cxx
echo   c.f ();                  >> ..\src\c.cxx
echo   return (0);              >> ..\src\c.cxx
echo }                          >> ..\src\c.cxx

echo #include "B.h"              > ..\src\d.cxx
echo #include "C.h"             >> ..\src\d.cxx
echo #include "D.h"             >> ..\src\d.cxx
echo int main ()                >> ..\src\d.cxx
echo {                          >> ..\src\d.cxx
echo   B b;                     >> ..\src\d.cxx
echo   b.f ();                  >> ..\src\d.cxx
echo   C c;                     >> ..\src\d.cxx
echo   c.f ();                  >> ..\src\d.cxx
echo   D d;                     >> ..\src\d.cxx
echo   d.f ();                  >> ..\src\d.cxx
echo   return (0);              >> ..\src\d.cxx
echo }                          >> ..\src\d.cxx

call setup
nmake /f nmake 
nmake /f nmake check

cd %CMTROOT%\contrib
