
import sys
import os

#------------------------------------------------------------
def CVSROOT () :
    return ('/dev/CMT/v1r7/demo/scenario4/cvsroot')
#------------------------------------------------------------

#------------------------------------------------------------
def scroot () :
    s = os.environ ['CMTROOT'] + '/demo/scenario4'
    return (s)
#------------------------------------------------------------

#------------------------------------------------------------
def remove_dir (d):
    if not os.path.exists (d) : return
    
    for f in os.listdir(d) :
        name = d + '/' + f
        if os.path.isdir (name) : remove_dir (name)
        else :
            os.chmod (name, 0777)
            os.remove (name)

    os.rmdir (d)
#------------------------------------------------------------

#------------------------------------------------------------
def setuses (package, uses) :
    prefix = os.path.dirname (package)
    name = os.path.basename (package)

    # print ('pre=[' + prefix + '] name=[' + name + ']')

    if prefix is '' : os.chdir (scroot ())
    else : os.chdir (scroot () + '/' + prefix)

    os.chdir (name)
    os.chdir ('v1/cmt')

    f = open ('requirements', 'a+b')

    for u in uses :
        p = os.path.dirname (u)
        n = os.path.basename (u)
        #print ('use ' + n + ' v1 ' + p)
        f.write ('use ' + n + ' v1 ' + p + '\n')
        
    f.close ()
    
#------------------------------------------------------------

#------------------------------------------------------------
def cvsimport (package, prefix = '') :
    if prefix is '' : os.chdir (scroot ())
    else : os.chdir (scroot () + '/' + prefix)
    
    if not os.path.exists ('CVS') : os.mkdir ('CVS')
    if not os.path.exists ('CVS/Entries') : 
        f = open ('CVS/Entries', 'wb')
        f.write ('\n')
        f.close ()
    if not os.path.exists ('CVS/Repository') : 
        f = open ('CVS/Repository', 'wb')
        f.write (prefix + '\n')
        f.close ()
    if not os.path.exists ('CVS/Root') : 
        f = open ('CVS/Root', 'wb')
        f.write (CVSROOT () + '\n')
        f.close ()

    os.system ('cvs -d ' + CVSROOT () + ' add ' + package)
    os.system ('cvs -d ' + CVSROOT () + ' ci -m "" ')

    os.chdir (package)
    os.chdir ('v1')

    if not os.path.exists ('CVS') : os.mkdir ('CVS')
    if not os.path.exists ('CVS/Entries') : 
        f = open ('CVS/Entries', 'wb')
        f.write ('\n')
        f.close ()
    if not os.path.exists ('CVS/Repository') : 
        f = open ('CVS/Repository', 'wb')
        if prefix is '' : f.write (package + '\n')
        else : f.write (prefix + '/' + package + '\n')
        f.close ()
    if not os.path.exists ('CVS/Root') : 
        f = open ('CVS/Root', 'wb')
        f.write (CVSROOT () + '\n')
        f.close ()

    os.system ('cvs -d ' + CVSROOT () + ' add src')
    os.system ('cvs -d ' + CVSROOT () + ' add cmt')
    os.system ('cvs -d ' + CVSROOT () + ' ci -m "" ')
    
    os.chdir ('cmt')
    os.system ('cvs -d ' + CVSROOT () + ' add requirements')
    os.system ('cvs -d ' + CVSROOT () + ' ci -m "" ')
    os.system ('cvs -d ' + CVSROOT () + ' tag v1 ')
    os.system ('cvs -d ' + CVSROOT () + ' tag v1r1 ')
    os.system ('cvs -d ' + CVSROOT () + ' tag v1r2 ')
    os.system ('cvs -d ' + CVSROOT () + ' tag v2 ')
    os.system ('cvs -d ' + CVSROOT () + ' tag v2r1 ')

#------------------------------------------------------------

remove_dir (scroot ())

os.mkdir (scroot ())
os.chdir (scroot ())

os.system ('cmt create A v1')
os.system ('cmt create B v1 A')
os.system ('cmt create C v1 A/B')
os.system ('cmt create D v1 A/B')
os.system ('cmt create E v1 A')
os.system ('cmt create F v1 A')
os.system ('cmt create G v1 ')
os.system ('cmt create H v1 ')
os.system ('cmt create I v1 H')
os.system ('cmt create J v1 H/I')
os.system ('cmt create K v1 H/I/J')

setuses ('A/B/D', ['A/B/C']);
setuses ('A/E',   ['A/B/C']);
setuses ('A/F',   ['A/B/D']);
setuses ('G',     ['A/B', 'A/B/D', 'A/E']);
setuses ('H/I',   ['A/E']);
setuses ('H/I/J', ['A/B/C', 'A/B/D']);

# sys.exit ()

os.system ('cvs -d ' + CVSROOT () + ' init')

cvsimport ('A')
cvsimport ('B', 'A')
cvsimport ('C', 'A/B')
cvsimport ('D', 'A/B')
cvsimport ('E', 'A')
cvsimport ('F', 'A')
cvsimport ('G')
cvsimport ('H')
cvsimport ('I', 'H')
cvsimport ('J', 'H/I')

