//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_branch_h__
#define __cmt_branch_h__

#include "cmt_parser.h"
#include "cmt_system.h"

class Branch
{
public:
  typedef cmt_vector<Branch> BranchVector;

  static void action (const CmtSystem::cmt_string_vector& words);
  static Branch* find (const cmt_string& name);
  static void add (const cmt_string& name);
  static void print_all (PrintMode mode);
  static void clear_all ();
  static BranchVector& branches ();

public:
  Branch ();
  ~Branch ();
  const cmt_string& name () const;
  void print (PrintMode mode) const;

private:
  cmt_string m_name;
};

#endif
