#ifndef __TCmThread_hxx__
#define __TCmThread_hxx__

#include <string>

class TCmThread
{
public:
  static void set_debug_level (int level);
  static int debug_level ();

  TCmThread ();
  virtual ~TCmThread ();
  bool start ();
  bool stop ();
  virtual void run ();
  virtual void cleanup ();

protected:
  static void run_it (TCmThread* thread);
  long _thread_id;
  bool _running;
  bool _should_die;

private:
  static void do_cleanup (void* thread);
};

class TCmMutex
{
public:
  static void iolock ();
  static void iounlock ();

public:
  TCmMutex ();
  TCmMutex (const std::string& info);
  ~TCmMutex ();
  void set_info (const std::string& info);
  bool trylock (const std::string& info = "");
  void lock (const std::string& info = "");
  void unlock ();
  std::string show () const;

private:
  static TCmMutex& get_iolock ();
  void initialize ();

  void* _mutex;
  std::string m_info;
  std::string m_context;
  int m_count;
};

#endif

