

#------------------------------------------------------------------
# This script tries to rebuild various elements of one CMT release
#
# The binaries on:
#   Linux (atlas.lal.in2p3.fr)
#   OSF1  (asc)
#   SunOS (ccasn)
#   AIX   (ccars)
#   Darwin (mac-ls3)
#   LynxOS (ax12+rio36a)
#
# RPM and doxygen (lx1)
#
# gendoc + pdf (lxplus)
#
# What is NOT automatic is the build on VisualC and CYGWIN
# For this we still need to 
#   1) log onto Vmware
#   2) checkout
#   3) rebuild on VisualC 
#        nmake /f nmake
#        nmake /f nmake cmttag
#   4) rebuild on CYGWIN
#        make
#   5) check in the result of the rebuild VisualC 
#   6) transfer the result to /lal/CMT/...
#
# At the end, the ast operations are:
#
#  1) cvs tag ${version}
#  2) gmake Export
#
#------------------------------------------------------------------

##set -x

version=`pwd`
version=`dirname ${version}`
version=`basename ${version}`

CVSROOT=:pserver:anonymous@cvsserver.lal.in2p3.fr:/projects/cvs
rwCVSROOT=:pserver:arnault@cvsserver.lal.in2p3.fr:/projects/cvs

at_lal=/lal
at_tmp=/tmp/tmpcmt
at_virgo=/virgoDev
at_lyon=/afs/in2p3.fr/home/throng/lalorsay
at_cern=/afs/cern.ch/sw/contrib

# For LAL machines

cmd_lal="(cd ${at_lal}/CMT; \
 cd ${version}/mgr; \
 ./INSTALL; \
 source setup.csh; \
 gmake)"

# For sh machines anywhere

shcmd1="(rm -rf ${at_tmp}/CMT; \
 mkdir -p ${at_tmp}/CMT; \
 cd ${at_tmp}/CMT; \
 cvs -d ${CVSROOT} co -d ${version} CMT; \
 cd ${version}/mgr; \
 ./INSTALL; \
 source setup.sh; \
 make)"

# For csh machines anywhere

cshcmd1="(rm -rf ${at_tmp}/CMT; \
 mkdir -p ${at_tmp}/CMT; \
 cd ${at_tmp}/CMT; \
 cvs -d ${CVSROOT} co -d ${version} CMT; \
 cd ${version}/mgr; \
 ./INSTALL; \
 source setup.csh; \
 make)"

# For Virgo machines

cmd_virgo="(cd ${at_virgo}/CMT; \
 cvs -d ${CVSROOT} co -d ${version} CMT; \
 cd ${version}/mgr; \
 ./INSTALL; \
 source setup.csh; \
 gmake; \
 rsh rio36a \"(cd ${at_virgo}/CMT/${version}/mgr; source setup.csh; make)\")"

# For csh machines anywhere

cmd_lyon="(mkdir -p ${at_lyon}/CMT; \
 cd ${at_lyon}/CMT; \
 cvs -d ${CVSROOT} co -d ${version} CMT; \
 cd ${version}/mgr; \
 ./INSTALL; \
 source setup.csh; \
 make)"

# For creating rpm and doxygen LAL machines

cmd_rpm="(cd ${at_lal}/CMT; \
 cd ${version}/mgr; \
 ./INSTALL; \
 source setup.csh; \
 gmake doxygen; \
 gmake rpm)"

# For sh machines at CERN

cmd_cern="(cd ${at_cern}/CMT; \
 cvs -d ${rwCVSROOT} co -d ${version} CMT; \
 cd ${version}/mgr; \
 ./INSTALL; \
 source setup.sh; \
 gmake; \
 cd; \
 source setup.sh; \
 cd ${at_cern}/CMT/${version}/mgr; \
 gmake gendoc pdf; \
 cd ../doc; \
 cvs -d ${rwCVSROOT} ci -m gendoc)"


#targets="arnault#atlas.lal.in2p3.fr#Linux#cmd_lal#${at_lal} \
#arnault#asc.lal.in2p3.fr#OSF1#cmd_lal#${at_lal} \
#arnault#ccasn.in2p3.fr#SunOS#cmd_lyon#${at_lyon} \
#arnault#ccars.in2p3.fr#AIX#cmd_lyon#${at_lyon} \
#arnault#ccali.in2p3.fr#Linux#cmd_lyon# \
#arnault#mac-ls3.lal.in2p3.fr#Darwin#cshcmd1#${at_tmp} \
#arnault#ax12.virgo.infn.it#LynxOS#cmd_virgo#${at_virgo} \
#arnault#lx1.lal.in2p3.fr#Linux#cmd_rpm# \
#carnault#lxplus.cern.ch#Linux#cmd_cern#"

targets="arnault#ccasn.in2p3.fr#SunOS#cmd_lyon#${at_lyon} \
arnault#ccars.in2p3.fr#AIX#cmd_lyon#${at_lyon} \
arnault#ccali.in2p3.fr#Linux#cmd_lyon# \
arnault#mac-ls3.lal.in2p3.fr#Darwin#cshcmd1#${at_tmp} \
arnault#ax12.virgo.infn.it#LynxOS#cmd_virgo#${at_virgo}"

selected=$1

for t in `echo ${targets}`; do
  user=`echo ${t} | cut -d# -f1`
  machine=`echo ${t} | cut -d# -f2`
  system=`echo ${t} | cut -d# -f3`
  cmd=`echo ${t} | cut -d# -f4`
  where=`echo ${t} | cut -d# -f5`

  cmd=`eval echo '${'"${cmd}"'}'`

  if test ! "${selected}" = ""; then
    if test ! "${selected}" = "${machine}"; then
      continue
    fi
  fi

  echo "Trying [${cmd}] on machine ${machine} where=${where}"
  ssh -x -l ${user} ${machine} "${cmd}" 2>&1 | cat >| build${machine}.log

  if test ! "${where}" = ""; then
    mkdir -p ../${system}
    scp ${user}@${machine}:${where}/CMT/${version}/${system}/cmt.exe ../${system}/cmt.exe
  fi

done



