//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_include_h__
#define __cmt_include_h__

#include "cmt_parser.h"
#include "cmt_system.h"

class Include
{
public:
  typedef cmt_vector<Include> IncludeVector;

  static void action (const CmtSystem::cmt_string_vector& words, Use* use);
  static Include* find (const cmt_string& name, Use* use);
  static Include* add (const cmt_string& name, Use* use);
  static void parse_all (Use* use);
  static void clear_all ();

public:
  Include ();
  ~Include ();
  void parse ();
  void clear ();

  cmt_string name;
  Use* use;
};

#endif
