

set -x

version=v1r14

#-------------------------------------------------------------
# Install a local RPM database
#-------------------------------------------------------------

tempdir=/tmp/CMT

rm -rf ${tempdir}

database=${tempdir}/rpm-database

mkdir -p ${database}

rpm --dbpath ${database} --initdb
rpm --dbpath ${database} -Uvh virtual.rpm

rpm --dbpath ${database} -e CMT

#-------------------------------------------------------------
# Now Install from the source RPM
#-------------------------------------------------------------

tempdir1=$1

if test "${tempdir1}" = ""; then
  tempdir1=/tmp/CMT1
  rm -rf ${tempdir1}
  mkdir -p ${tempdir1}
fi

rm -rf ${tempdir1}
mkdir -p ${tempdir1}

rpm --dbpath ${database} -Uvh --relocate /CMT=${tempdir1}/CMT \
  --define "_topdir ${tempdir1}" \
  ../rpm/CMT-${version}-1.src.rpm




