//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_deps_builder_h__
#define __cmt_deps_builder_h__

#include "cmt.h"
#include "cmt_system.h"

class DepsBuilder
{
public:

  void clear ();
  void add (const cmt_string& path, const cmt_string& substitution);
  void add_includes (const Use& use);
  CmtSystem::cmt_string_vector& run (const cmt_string& file_name);

private:

  CmtSystem::cmt_string_vector m_include_paths;
  CmtSystem::cmt_string_vector m_substitutions;

  CmtSystem::cmt_string_vector m_deps;
  CmtSystem::cmt_string_vector m_all_deps;

};

#endif
