#!/bin/sh -f

set -x

#----------------------------------------------------------
build_version ()
#----------------------------------------------------------
{
  #
  # arg1 = "version"
  # arg2 = DetectorDescription-00-00-11:19990122114459 
  #
  #   Convert a-b-c into v<b>r<c>
  #
  #   (might be v<a>r<b>p<c> instead)
  #

  #tag=`echo $2 | cut -d':' -f1 | cut -d'-' -f3-4`
  #version=`echo $tag | cut -d'-' -f1 | sed 's#^0##'`
  #release=`echo $tag | cut -d'-' -f2 | sed 's#^0##'`
  #echo v${version}r${release}

  echo "v2r1"
}

#----------------------------------------------------------
install_cvs ()
#----------------------------------------------------------
{
  #
  # Install all required management files for a directory.
  #
  #   CVS/Entries     (empty)
  #   CVS/Root        (filled in with current $CVSROOT)
  #   CVS/Repository  (filled in with current $CVSROOT/$1)
  #
  repository=$1

  if test ! -d CVS ; then
    mkdir CVS
  fi

  if test ! -d CVS/Entries ; then
    cat <<END >CVS/entries
END
  fi

  if test ! -d CVS/Root ; then
    cat <<END >CVS/Root
${CVSROOT}
END
  fi

  if test ! -d CVS/Repository ; then
    cat <<END >CVS/Repository
${CVSROOT}/${repository}
END
  fi

}

#----------------------------------------------------------
install_cvs_branch ()
#----------------------------------------------------------
{
  #
  #  Manually add a branch entry in the CVS/Entries file
  #  (avoid duplications)
  #
  branch=$1

  a=`egrep -e "/${branch}/" CVS/Entries`

  if test "${a}" = "" ; then
    cat <<END >>CVS/Entries
D/${branch}////
END
  fi
}

#----------------------------------------------------------
do_help ()
#----------------------------------------------------------
{
  cat <<END
 > srt2cmt.sh <package> <package> ...

 Checkout packages (commited using the SRT organisation) from CVS,
 and install them using the cmt organisation.

 The following conventions are used :

 files from :           go to :
 <package>/             <package>/<version>/cmt/
 <package>/<branch>/    <package>/<version>/<branch>/

END
}

#----------------------------------------------------------
work ()
#----------------------------------------------------------
{
  target=$1

  echo "================= working in target ${target}"

  for package_file in `find ${root}/${target} -name PACKAGE,v -print` ; do

    echo "================= working on package_file ${package_file}"

    package=`dirname ${package_file} | sed -e "s#${root}/##"`

    echo "================= package is ${package}"

    cd ${home_dir}

    #
    #  First of all export the PACKAGE file to get basic infos (version)
    # about the package.
    #
    mkdir -p ${package}
    cvs export -r HEAD -d ${package} offline/${package}/PACKAGE

    tag=`grep version ${package}/PACKAGE` 
    title=`grep title ${package}/PACKAGE` 
    author=`grep author ${package}/PACKAGE` 

    echo ${tag} ${title} ${author}

    /bin/rm -f ${package}/PACKAGE

  done
}

#----------------------------------------------------------
# main ()
#----------------------------------------------------------

#if test "$#" = "0" ; then
#  do_help
#  exit 1
#fi

case "$1" in
  --help)
	  do_help
	  exit 1
	  ;;
esac

home_dir=`pwd`

root=$CVSROOT/offline

#for target in $* ; do
#done

work


