//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_database_h__
#define __cmt_database_h__

#include "cmt_vector.h"

#include "cmt_branch.h"
#include "cmt_constituent.h"
#include "cmt_fragment.h"
#include "cmt_group.h"
#include "cmt_language.h"
#include "cmt_pattern.h"
#include "cmt_use.h"
#include "cmt_symbol.h"
#include "cmt_project.h"
#include "cmt_cmtpath_pattern.h"

class Database
{
public:

  static Database& instance ();

  static void clear ();

  static Branch::BranchVector& branches ();
  static Constituent::ConstituentVector& constituents ();
  static Fragment::FragmentVector& fragments ();
  static Group::GroupVector& groups ();
  static Language::LanguageVector& languages ();

  static Package::PackageVector& packages ();
  static Package::PackageMap& package_map ();

  static Pattern::PatternVector& patterns ();

  static PatternList::PatternListMap& pattern_list_map ();
  static PatternList::PatternListVector& pattern_lists ();

  static Use::UseVector& all_uses ();
  static Use::UsePtrVector& uses ();

  static Symbol::SymbolVector& symbols ();
  static Symbol::SymbolMap& symbol_map ();

  static Tag::TagVector& all_tags ();
  static Tag::TagPtrVector& tags ();
  static Tag::TagMap& tag_map ();

  static Project::ProjectVector& projects ();

  static CmtPathPattern::CmtPathPatternVector& cmtpath_patterns ();

private:

  Database ();

  Branch::BranchVector m_branches;
  Constituent::ConstituentVector m_constituents;
  Fragment::FragmentVector m_fragments;
  Group::GroupVector m_groups;
  Language::LanguageVector m_languages;

  Package::PackageVector m_packages;
  Package::PackageMap m_package_map;

  Pattern::PatternVector m_patterns;

  PatternList::PatternListMap m_pattern_list_map;
  PatternList::PatternListVector m_pattern_lists;

  Use::UseVector m_all_uses;
  Use::UsePtrVector m_uses;
  Symbol::SymbolVector m_symbols;
  Symbol::SymbolMap m_symbol_map;
  Tag::TagVector m_all_tags;
  Tag::TagPtrVector m_tags;
  Tag::TagMap m_tag_map;
  Project::ProjectVector m_projects;

  CmtPathPattern::CmtPathPatternVector m_cmtpath_patterns;

};

#endif
