#!/bin/sh

#---------------------------------------------------------------------
#
# This script should be installed within the loginfo file of CVS
# using the following line :
#
# ...
#.cmtcvsinfos $CVSROOT/CVSROOT/cmt_buildcvsinfos2.sh
# ...
#
# and is used whenever one tries to import a module named .cmtcvsinfos/<module>
#
#---------------------------------------------------------------------

#set -x

#---------------------------------------------------------------------
get_cvsroot ()
{
  echo ${CVSROOT} | sed -e 's#^:[^:]*:##'
}

#---------------------------------------------------------------------
check_head ()
{
  head=$1
  version=$2

  echo "${head} ${version}" | awk '{\
   head = $1; \
   version = $2; \
   nh = split (head, hlist); \
   nv = split (version, vlist); \
   for (i = 0; i < nh; i++) \
   { \
     if (hlist[i] != vlist[i]) \
     { \
       print "0"; \
       next; \
     } \
   } \
   print "1"; \
}'
}

#---------------------------------------------------------------------
check_newer ()
{
  v1=$1;
  v2=$2;

  #echo "check_newer v1=${v1} v2=${v2}"

  if test "${v2}" = ""; then
    echo "1"
    return
  fi

  echo "${v1} ${v2}" | awk '{\
   v1 = $1;\
   v2 = $2;\
   n1 = len (v1);\
   if (n1 == 0) \
   {\
     print "0";\
     next;\
   }\
   n1 = split (v1, list1);\
   if (n1 == 0) \
   {\
     print "0";\
     next;\
   }\
   n2 = split (v2, list2);\
   for (i = 0; i < n1; i++)\
   {\
     if (i > n2)\
     {\
       print "1";\
       next;
     }\
     if (list1[i] > list2[i])\
     {\
       print "1";\
       next;
     }\
   }\
   print "0";\
}'
}

#---------------------------------------------------------------------
get_tags ()
{
  module=$1

  if test -r "${CVSROOT}/${module}/cmt/requirements,v" ; then
    test_file="${CVSROOT}/${module}/cmt/requirements,v"
  elif test -r "${CVSROOT}/${module}/mgr/requirements,v" ; then
    test_file="${CVSROOT}/${module}/mgr/requirements,v"
  else
    test_file=`find "${CVSROOT}/${module}" -name '*,v' -print | head -n 1`
  fi

#  tags=`tr ' ' '\n' < "${test_file}" | \
#   awk '/symbols/,/locks/ {n=split($0,w,"."); if ((n == 2) || (n == 4) || (n == 6)) print; }'  | \
#   sed -e 's#:.*##' -e 's#[ 	]*##'`
#  print "${tags}"

  started=0
  finished=0
  top=
  toptags=
  cvstags=

#symbols
#	v10:1.1.1.1
#	v2:1.1.1.1
#	v1r2:1.1.1.1
#	v1r1:1.1.1.1
#	v1:1.1.1.1
#	cmt:1.1.1;
#locks; strict;
  
  alltags=`tr ' ' '\n' < "${test_file}" | \
   awk '/symbols/,/locks/ { \
     if (done == 1) next; \
     n = split ($0,w,"."); \
     if ((n != 2) && (n != 4) && (n != 6)) next; \
     if ($1 == "symbols") \
     { \
       print $2; \
     } \
     else \
     { \
       print $1; \
     } \
     if ($1 == "locks;") done = 1; \
   }'`

  for t in ${alltags}; do
    tag=`echo ${t} | sed -e 's#:.*##'`
    v=`echo ${t} | sed -e 's#.*:##'`

    if test `check_newer ${v} ${top}` = "1"; then
      top=${v}
    fi
  done

  tags=

  for t in ${alltags}; do
    tag=`echo ${t} | sed -e 's#:.*##'`
    v=`echo ${t} | sed -e 's#.*:##'`

    if test "${v}" = "${top}"; then
      tags="${tags} ${tag}(t) "
    else
      tags="${tags} ${tag} "
    fi

  done

  echo "${tags}"
}

#---------------------------------------------------------------------
get_branches ()
{
  module=$1

  branches=
  for branch in `ls "${CVSROOT}/${module}" | grep -v Attic` ; do
    if test -d "${CVSROOT}/${module}/${branch}" ; then
      if test ! -r "${CVSROOT}/${module}/${branch}/cmt/requirements,v" ; then
	if test ! -r "${CVSROOT}/${module}/${branch}/mgr/requirements,v" ; then
	  if test "${branches}" = "" ; then
	    branches="${branch}"
	  else
	    branches="${branches} ${branch}"
	  fi
	fi
      fi
    fi
  done
  echo "${branches}"
}

#---------------------------------------------------------------------
get_subpackages ()
{
  module=$1

  subpackages=
  for branch in `ls "${CVSROOT}/${module}" | grep -v Attic` ; do
    if test -d "${CVSROOT}/${module}/${branch}" ; then
      if test -r "${CVSROOT}/${module}/${branch}/cmt/requirements,v" ; then
	if test "${subpackages}" = "" ; then
	  subpackages="${branch}"
	else
	  subpackages="${subpackages} ${branch}"
	fi
      elif test -r "${CVSROOT}/${module}/${branch}/mgr/requirements,v" ; then
	if test "${subpackages}" = "" ; then
	  subpackages="${branch}"
	else
	  subpackages="${subpackages} ${branch}"
	fi
      fi
    fi
  done
  echo "${subpackages}"
}

#---------------------------------------------------------------------
# main
#---------------------------------------------------------------------

rm -f -r $CVSROOT/.cmtcvsinfos/*

read a

root=$CVSROOT

module=`echo $a | sed -e "s#.*[.]cmtcvsinfos/##"`
error=

if test "${module}" = "" ; then
  echo "error=syntax error"
  exit 1
fi

tags=
tags_top=

if test -d "${CVSROOT}/${module}" ; then
  alltags=`get_tags ${module}`
  for t in ${alltags}; do
    a=`echo ${t} | grep '[(]t[)]$'`
    is_top=$?
    if test "${is_top}" = 1; then
      if test "${tags}" = ""; then
	tags="${t}"
      else
	tags="${tags} ${t}"
      fi
    else
      t=`echo ${t} | sed -e 's#(t)##'`

      if test "${tags_top}" = ""; then
	tags_top="${t}"
      else
	tags_top="${tags_top} ${t}"
      fi
    fi
  done
else
  error="### Module ${module} not found."
fi

branches=
if test -d "${CVSROOT}/${module}" ; then
  branches=`get_branches ${module}`
fi

subpackages=
if test -d "${CVSROOT}/${module}" ; then
  subpackages=`get_subpackages ${module}`
fi

if test ! "${error}" = ""; then
  echo error=${error}
fi

echo tags_top=${tags_top}
echo tags=${tags}
echo branches=${branches}
echo subpackages=${subpackages}

exit 1


