#!/bin/sh -f

if test $# -lt 2 ; then
  echo "Usage : " 1>&2
  echo "> cmt_export.sh <Package> <file> [<prefix>]" 1>&2
  exit 1
fi

package=$1
file=$2

if test $# = 3 ; then
  prefix=$3
else
  prefix=
fi

echo "> cmt_export.sh ${package} ${file} ${prefix}"

if test ${package} = "CMT/"; then
  website=/www/Web/htdocs/cmtsite
elif test ${package} = "CMT"; then
  website=/www/Web/htdocs/cmtsite
else
  website=/www/Web/htdocs/html/SI/${package}
fi

if test "${FTPPATH}" = "" ; then
  dest=${website}/${prefix}
else
  dest="${FTPPATH}"
fi

if test ! -d ${dest} ; then
  mkdir -p ${dest}
fi

unset noclobber

echo "> cp ${file} ${dest}"
cp -R ${file} ${dest}
##if test ! `pwd` = `(cd ${dest}; pwd)` ; then
##  /bin/rm -f ${file}
##fi


