#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

BEGIN {started = 0; running = 0; if (style == "") { vdir = "/v1"; } else { vdir = ""; }}
{
  line = $0;

  if ($1 == "%%package")
  {
    if (running)
      {
	print "END";
	running = 0;
      }
    package = $2;
    print "cmt create " package " v1";
    filename = package vdir "/cmt/requirements";
    started = 1;
  }
  else if ($1 == "%%file") 
  {
    if (running)
      {
	print "END";
	running = 0;
      }
    file = $2;
    print "mkdir -p `dirname " package vdir "/" file "`";
    filename = package vdir "/" file; 
    started = 1;
  }
  else
  {
    gsub ("[$]", "\\$", line);
    print line;
  }

  if (started)
    {
      started = 0;
      print "cat <<END >" filename;
      running = 1;
    }
}

