//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

class iterator
{
  public:
  iterator ()
      {
        _index = 0;
        _vector = 0;
      }

  iterator (cmt_vector& vector)
      {
        _index = 0;
        _vector = &vector;
      }

  iterator (const iterator& other)
      {
        _index = other._index;
        _vector = other._vector;
      }

  iterator& operator = (const iterator& other)
      {
        _index = other._index;
        _vector = other._vector;

        return (*this);
      }

  bool operator == (const iterator& other)
      {
        if (_vector != other._vector) return (false);
        if (_index != other._index) return (false);

        return (true);
      }

  iterator& operator ++ ()
      {
        if (_vector != 0)
          {
            _index++;
          }

        return (*this);
      };

  iterator& operator -- ()
      {
        return (*this);
      };

  int operator - (const iterator* other)
      {
        return (0);
      };

  iterator operator + (int offset)
      {
        iterator it = *this;
        return (it);
      };

  iterator operator - (int offset)
      {
        iterator it = *this;
        return (it);
      };

  T& operator * ()
      {
        return ();
      };

  private:
  int _index;
  cmt_vector* _vector;
};
