#!/bin/sh -f

###set -x

#------------------------------------------------------------------------------
#
# -source=1   absolute source directory
# -name=2     file name
# -out=3      absolute installation directory
# -cmtpath=4  cmtpath of the package
#
#------------------------------------------------------------------------------

source_dir=""
file_name=""
install_dir=""
install_command=""
cmtpath=""

#handle_args $*
#
#------------------------------------------------------------------------------
#handle_args ()
#{
  opt="-source"

  while test "$#" -gt 0; do
    arg=$1
    shift

    val=${arg}
    
    case ${arg} in
      -*)
        if echo $arg | grep '=' 2>&1 >/dev/null; then
          opt=`echo ${arg} | sed -e 's#=.*##'`
	  val=`echo ${arg} | sed -e 's#[^=]*=##'`
	else
	  opt=${arg}
	  val=
	  if test "$#" -gt 0; then
	    val=$1
	    shift
	  fi
	fi
	;;
    esac
    
    case ${opt} in
      -source)
	source_dir=${val};
	opt="-name";
	;;
      -name)
	file_name=${val};
	opt="-out";
	;;
      -out)
	install_dir=${val};
	opt="-cmd";
	;;
      -cmd)
	install_command=${val};
	opt="-cmtpath";
	;;
      -cmtpath)
	cmtpath=${val};
	opt="";
	;;
      *)
	;;
    esac
    
  done
    
  if test "${source_dir}" = ""; then
    echo "cmt_uninstall_action.sh> no source directory"
    exit 1
  fi
    
  if test "${file_name}" = ""; then
    echo "cmt_uninstall_action.sh> no file name"
    exit 1
  fi
    
  if test "${install_dir}" = ""; then
    echo "cmt_uninstall_action.sh> no install dir"
    exit 1
  fi

  if test "${cmtpath}" = ""; then
    package=`cmt show macro_value package`
    cmtpath=`cmt show macro_value ${package}_cmtpath`
  fi

  if test "${cmtpath}" = ""; then
    echo "cmt_uninstall_action.sh> no cmtpath"
    exit 1
  fi
#}

dest_file_path=${install_dir}/${file_name}
ref_file=${dest_file_path}.cmtref
full_source_name=${source_dir}/${file_name}

b=`(cd ${cmtpath}; /bin/pwd)`
a=`/bin/pwd | grep -e "${b}"`
if test "${a}" = ""; then
  echo "Current directory outside of the installation area. Cannot proceed"
  exit 0
fi

if test "${install_dir}" = "" ; then
  exit 0
fi

if test ! -d ${install_dir}; then
  echo "Cannot uninstall file ${file_name}, no installation directory specified"
  exit 0
fi

if test -d ${dest_file_path}; then
  echo Removing directory ${file_name} from ${install_dir}
  /bin/rm -rf ${dest_file_path}
elif test -f ${dest_file_path}; then
  echo Removing file ${file_name} from ${install_dir}
  /bin/rm -f ${dest_file_path}
fi

if test -f ${ref_file}; then
  /bin/rm -f ${ref_file}
fi

