//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_install_area_h__
#define __cmt_install_area_h__

class CmtInstallPathPattern
{
public:
  cmt_string m_name;
  cmt_string m_definition;
};

class CmtInstallAreaMgr
{
public:
  static CmtInstallAreaMgr& instance ();

public:
  void setup_current_installarea ();
  void setup ();
  void config () const;
  const cmt_string& get_installarea () const;

private:
  cmt_string build_current_installarea () const;
  
  cmt_vector <CmtInstallPathPattern> m_patterns;
  cmt_string m_installarea;
};

#endif
