//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#include "cmt_sequence.h"
#include "cmt_system.h"

SequenceRunner::SequenceRunner ()
{
}

void SequenceRunner::begin ()
{
  started = false;
  running = false;
  if (style == CmtSystem::getenv ("CMTSTRUCTURINGSTYLE"))
    {
      vdir = CmtSystem::file_separator (); 
      vdir += "v1"; 
    } 
  else
    {
      vdir = ""; 
    }
  package = "";
  filename = "";
  buffer = "";
  pwd = "";
}

void SequenceRunner::filter (const cmt_string& line)
{
    //cout << "line=[" << line << "]" << endl;
  
  CmtSystem::cmt_string_vector words;
  
  CmtSystem::split (line, " \t", words);
  
  cmt_string verb;
  
  if (words.size () > 0) verb = words[0];
  
  if (verb.substr (0, 2) == "%%")
    {
      if (verb.substr (0, 3) == "%%%") return;
      
      if (running)
        {
          buffer.write (filename);
	  cout << "%%Writing file " << filename << endl;
            //cout << buffer << endl;
          buffer = "";
          
          running = false;
        }
    }
  
  if (verb == "%%package")
    {
      package = words[1];
      version = words[2];
      
      if (version == "") version = "v1";
      
      cmt_string command = "cmt create ";
      command += package;
      command += " ";
      command += version;
      
      CmtSystem::execute (command);
      cout << "%% creating package " << package << " with command [" << command << "]" << endl;

      if (style == CmtSystem::getenv ("CMTSTRUCTURINGSTYLE"))
        {
          vdir = CmtSystem::file_separator (); 
          vdir += version; 
        } 
      else
        {
          vdir = ""; 
        }
      
      filename = package;
      filename += vdir;
      filename += CmtSystem::file_separator ();
      filename += "cmt";
      filename += CmtSystem::file_separator ();
      filename += "requirements";
      
      started = true;
    }
  else if (verb == "%%file") 
    {
      cmt_string file = words[1];
      
      cmt_string d = package;
      d += vdir;
      d += CmtSystem::file_separator ();
      d += file;
      CmtSystem::dirname (d, d);
      
      CmtSystem::mkdir (d);
      cout << "%% creating directory " << d << endl;

      buffer = "";
      
      filename = package;
      filename += vdir;
      filename += CmtSystem::file_separator ();
      filename += file; 
      started = true;
    }
  else if (verb == "%%cdpackage") 
    {
      package = words[1];
      
      pwd = package;
      pwd += vdir;
      pwd += CmtSystem::file_separator ();
      pwd += "cmt";
      cout << "%% moving to package " << package << endl;
    }
  else if (verb == "%%cmt") 
    {
      cmt_string command;
      
      if (pwd != "")
        {
          command = "cd ";
          command += pwd;
          command += " ";
          command += CmtSystem::command_separator ();
          command += " ";
        }
      
      command += line;
      command.replace ("%%", "");
      
      cout << "%% executing cmt command " << line << endl;

      CmtSystem::execute (command);
    }
  else
    {
      buffer += line;
      buffer += "\n";
    }
  
  if (started)
    {
      started = false;
      running = true;
    }
}

void SequenceRunner::end ()
{
  if (running)
    {
      if (buffer != "")
        {
          buffer.write (filename);
	  cout << "%%Writing file " << filename << endl;
            //cout << buffer << endl;
          buffer = "";
        }
      running = false;
    }
}


