//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// Modified by garonne@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_syntax_h__
#define __cmt_syntax_h__

#include "cmt_map.h"
#include "cmt_string.h"
#include "cmt_system.h"
#include "cmt_use.h"
#include "cmt_project.h"

class Kwd
{
public:
  virtual void action (const CmtSystem::cmt_string_vector& words,
		       Use* use,
		       const cmt_string& file_name,
		       int line_number) = 0;

  virtual void action (const CmtSystem::cmt_string_vector& words,
		       Project* project,
		       const cmt_string& file_name,
		       int line_number) = 0;
};

class SyntaxParser
{
public:
  static SyntaxParser& instance ();

  static void parse_requirements (const cmt_string& file_name, Use* use);

  static void parse_project_file_text (const cmt_string& text,
				       const cmt_string& file_name,
				       Project* project);

  static void parse_requirements_text (const cmt_string& text,
				       const cmt_string& file_name,
				       Use* use);

  static void parse_requirements_line (const cmt_string& line,
				       Use* use,
				       const cmt_string& file_name = "",
				       int line_number = 0);

private:

  typedef enum
    {
      project_context,
      package_context
    } ContextType;

  void do_parse_requirements (const cmt_string& file_name, Use* use);

  void do_parse_text (const cmt_string& text,
		      const cmt_string& file_name,
		      ContextType context,
		      Use* use,
		      Project* project);

  void do_parse_line (const cmt_string& line,
		      const cmt_string& file_name,
		      int line_number,
		      ContextType context,
		      Use* use,
		      Project* project);

  void do_parse_words (const CmtSystem::cmt_string_vector& words,
		       const cmt_string& file_name,
		       int line_number,
		       Use* use);

  void do_parse_words (const CmtSystem::cmt_string_vector& words,
		       const cmt_string& file_name,
		       int line_number,
		       Project* project);

  SyntaxParser ();
  cmt_map <cmt_string, Kwd> m_keywords;
  cmt_map <cmt_string, Kwd> m_project_keywords;
  cmt_string m_filtered_text;
};


#endif
