#!/usr/bin/env python
#--------------------------------#
# Author: V.garonne              #
# Mail: garonne@lal.in2p3.fr     #
# Description: script to export  #
# a CMT release to the web site  #
#--------------------------------#

import sys, os
import string
import commands
import shutil
import socket
import tarfile, gzip
import threading

# my own stuffs
from utils.ssh_session import *
from p3                import decrypt


# for package version dependant
import tarfile

# My own python 'tar -xvzf' in waiting python 2.5...
def extractall(tarball, path="."):
    tar         = tarfile.open(tarball)
    directories = []
    for tarinfo in tar:
        if tarinfo.isdir():
                try:
                    os.makedirs(os.path.join(path, tarinfo.name), 0777)
                except EnvironmentError:
                    pass
                directories.append(tarinfo)
        else:
            tar.extract(tarinfo, path)

    # Reverse sort directories.
    directories.sort   (lambda a, b: cmp(a.name, b.name))
    directories.reverse()

    # Set correct owner, mtime and filemode on directories.
    for tarinfo in directories:
        path = os.path.join(path, tarinfo.name)
        tar.chown(tarinfo, path)
        #tar.utime(tarinfo, path)
        #tar.chmod(tarinfo, path)
    tar.close()


#--------------------# MAIN #-------------------------#
#if __name__ == '__main__':  
def cmt_export_binaries (version):
    # variables
    proxy     = '.cmtproxy'
    preambule = 'cmt_export > '
    platforms = [
    'Linux-i686', 
    'Linux-x86_64', 
    'Linux-ia64',
    'VisualC',
    'CYGWIN_NT-5.1-i686',
    'Darwin-PowerMacintosh',
    ]
    
    if not os.path.exists (proxy):
        print preambule + 'First create the proxy'
        sys.exit(-1)
    pool    = eval(decrypt('.cmtproxy')) 
    machine = 'Linux-i686'
    host    = pool[machine]['machine']
    user    = pool[machine]['user']
    pwd     = pool[machine] ['pwd']
    session = ssh_session (user=user, host=host, password=pwd, verbose=1)
    
    for platform in platforms:
        file = 'CMT'+version+platform+'.tar.gz'    
        if os.path.exists(file):
            print file
            extractall(tarball=file)
    
    path = '/afs/cern.ch/sw/contrib/CMT/'
    session.scp ('CMT/'+version, path,'r') 
    session.ssh ('cd '+path+'/'+version+'/mgr; ./INSTALL')    
    
    for platform in platforms:
        if platform != 'VisualC':
            cmd = "ln -s "+" "+path+'/'+version+'/'+platform+'/cmt.exe'+" "+path+'/'+version+'/'+platform+'/cmt'
            session.ssh (cmd)     
    
    platforms = ['OSF1-alpha',]
    for platform in platforms:
        file = 'CMT'+version+platform+'.tar.gz'    
        if os.path.exists(file):
            print file
            extractall(tarball=file)
            
    machine = 'OSF1-alpha'
    host    = "lx.lal.in2p3.fr"     # pool[machine]['machine']
    user    = pool[machine]['user']
    pwd     = pool[machine] ['pwd']
    session = ssh_session (user=user, host=host, password=pwd, verbose=1)

    
    path = '/lal/CMT'
    session.scp ('CMT/'+version, path,'r') 
    cmd = "ln -s "+" "+path+'/'+version+'/'+platform+'/cmt.exe'+" "+path+'/'+version+'/'+platform+'/cmt'
    session.ssh (cmd)     
    session.ssh ('cd '+path+'/'+version+'/mgr; ./INSTALL')    

    
    shutil.rmtree ('CMT')
    
    
    
#----------------------- End Of File --------------------------#