#!/usr/bin/env python
#--------------------------------#
# Author: V.garonne              #
# Mail: garonne@lal.in2p3.fr     #
# Description: script to create  #
# automaticaly a release         #
#--------------------------------#

import pexpect
import sys, os
import string
import commands
import shutil
import socket
import tarfile, gzip

# my own stuffs
from utils.ssh_session import *

def cmt_finalize_release (root, version):
    svnroot   = root + '/HEAD'
    path      = 'tmp/CMT/'
    preambule = 'build_release > '
    hostname  =  socket.gethostname()
    tarballs  =  list()
    platforms = [
    'OSF1-alpha',
    'Linux-i686', 
    'Linux-x86_64', 
    'Linux-ia64',
    'SunOS-sun4u', 
    'AIX-002064874C00', 
    'VisualC',
    'CYGWIN_NT-5.1-i686',    
    'Darwin-PowerMacintosh'
    ]
    here      =  os.getcwd()
           
#     do a new fresh temp directory    
    if os.path.exists('tmp'):
        shutil.rmtree('tmp')
    os.makedirs (path)
    os.chdir    (path)

# first do a checkout of the HEAD
    print  preambule +'first do a svn co of the last version'    
    cmd    = 'svn co '+ svnroot
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    if status:
        print output
#        
#     User Questions
    print  preambule + 'Before doing a CMT release, did you check that :'
    print '\t You have change manually the old release number by '+ version +' in the doc/CMTDoc.xml file ? (y/n)'
    choice ='y'
    choice    = raw_input('--> ')
    if choice!='y' and choice!='Y': sys.exit(-1)
    print '\t and the CMT requirements file (only when major release changes) ? (y/n)'
    choice    = raw_input('--> ')
    if choice!='y' and choice!='Y': sys.exit(-1)
    print  preambule + 'now we can proceed to the release' 
# 
    print  preambule + 'Build the documentations'
    #make doxygen, doxygen must be installed localy
    cmd    =  'cd HEAD/doc; rm -Rf Doxygen; doxygen'
    print preambule + cmd 
    status, output = commands.getstatusoutput (cmd)
    print output
    # make the pdf, htlm2ps must be installed
    cmd    = 'cd HEAD/mgr; make pdf; make gendoc'
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    print output

    print '\t You should change manually the ReleaseNotes.html '
    choice    = raw_input('--> ')
    if choice!='y' and choice!='Y': sys.exit(-1)
      
    print preambule + 'commit version to the HEAD'
    os.chdir('HEAD')
    cmd = "svn commit -m 'version "+ version +"'"
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    print output
    os.chdir('..')
    
    print  preambule + 'Tag version', version 
    cmd = "svn copy -m 'move HEAD' "  + svnroot + ' ' + root + '/' + version
    print preambule + cmd 
    status, output = commands.getstatusoutput (cmd)
    print output    
    shutil.rmtree('HEAD')
    
    cmd = "svn  co " + root + '/' + version
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    print output    
    os.chdir    (version)

    # User Question
    content = '''
//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_version_h__
#define __cmt_version_h__

#define CMTVERSION "%s"

#endif
    '''%(version)
    

    print preambule + 'Change the version number in the cmt_version.h file'
    f = open ('source/cmt_version.h', 'w+')
    f.write (content)
    f.close ()

    print '\t Prepare the ../doc/download.html file'
    f = open ('doc/CMTDownload1.html','r')
    content = f.read ()
    f.close
    content = content + '  <tr><td><a href="CMT%s.tar.gz">Source kit</a> </td></tr>\n'%(version)
    for platform in platforms:
        content = content + '  <tr><td><a href="CMT%s%s.tar.gz">%s</a> </td></tr>\n'%(version, platform, platform)    
    f = open ('doc/CMTDownload2.html','r')
    content = content + f.read ()
    f.close    
    f = open ('doc/CMTDownload.html', 'w+')
    f.write (content)
    f.close ()    
    cmd = "svn add " + 'doc/CMTDownload.html'
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    print output

    print preambule + 'commit version'
    cmd = "svn commit -m 'version "+ version +"'"
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    print output
    os.chdir      (here)
    shutil.rmtree ('tmp')

#--------------------# MAIN #-------------------------#
if __name__ == '__main__':  
    pass
#----------------------- End Of File --------------------------#