#!/usr/bin/env python
#--------------------------------#
# Author: V.garonne              #
# Mail: garonne@lal.in2p3.fr     #
# Description: script to create  #
# automaticaly a release         #
#--------------------------------#

import pexpect
import sys, os
import string
import commands
import shutil
import socket
import tarfile, gzip
import threading

# my own stuffs
from utils.ssh_session import *
from p3                import decrypt

#--------------------# For the Multi-threaded version #-------------------------#
class constructor (threading.Thread):

  # static counter
  counter = 1
  def __init__(self, host, user, pwd, version, machine):
    self.host        = host
    self.user        = user
    self.pwd         = pwd
    self.version     = version
    self.machine     = machine
    print self.host, self.user, self.pwd  
    self.number      = constructor.counter     
    constructor.counter = constructor.counter + 1
    threading.Thread.__init__(self, target=self.run)
    
  def run (self):
        hostname  =  socket.gethostname()
        # first do a ssh connection    
        preambule = 'create_bintar '+ str(constructor.counter) +' > '
        if self.host != hostname:
            session = ssh_session (user=self.user, host=self.host, password=self.pwd, verbose=1)
            print session.ssh('hostname')
        # copy the source code on the build machine
        # in fact the input sandbox in grid terms
        if self.host != hostname:
            if os.path.exists ("CMT"+self.version+".tar.gz"):
                session.scp ("CMT"+self.version+".tar.gz",'.')
            else:
                print preambule + "CMT"+self.version+".tar.gz" + ' not found'
                sys.exit(-1)
            
            if os.path.exists ("tarfile.py"):
                session.scp ("tarfile.py",'.')
                
            if os.path.exists ("cmt_build_binaries"):    
                session.scp ("cmt_build_binaries",'.')
            else:
                print preambule + "cmt_build_binaries" + ' not found'
                sys.exit(-1)
                
        cmd = "./cmt_build_binaries "+ self.version + " "+ self.machine
        print preambule + cmd
        if self.host != hostname:
           print session.ssh(cmd)
        else:
            status, output = commands.getstatusoutput (cmd)
            print output
       
        # get bin directory
        file = 'CMT'+self.version+self.machine+'.tar.gz'
        if self.host != hostname:
            file = 'CMT'+self.version+self.machine+'.tar.gz'
            #session.scpget  (src='CMT/'+version+'/'+machine , dst='tmp/CMT/'+version+'/.', option='r')
            session.scpget  (file, '.')
            # Clean up
            cmd = 'rm -rf '+ file + ' CMT ;'
            print preambule + cmd
            session.ssh (cmd)
        else:
            
            print preambule + 'build the pacman kit'
            cmd = 'cd CMT/'+self.version+'/mgr/;'
            if sys.platform == 'darwin':
                cmd = cmd + 'make'
            else:
                cmd = cmd + 'gmake'
            status, output = commands.getstatusoutput (cmd)
            file = 'CMT-'+self.version+'.pacman'
            #shutil.copy ('CMT/'+self.version+'/mgr/CMT.pacman', 'CMT/'+self.version+'/mgr/' + file)                                                
            #shutil.copy ('CMT/'+self.version+'/mgr/' + file , file)
            print output
            #Clean up
            shutil.rmtree('CMT')

#--------------------# MAIN #-------------------------#
#if __name__ == '__main__':  
def cmt_create_bintar (version):
    path      = 'tmp/CMT/'
    proxy     = '.cmtproxy'
    preambule = 'build_release > '
    here      =  os.getcwd()
    hostname  =  socket.gethostname()
    tarballs  =  list()
    srctar    = "CMT"+version+".tar.gz"
    
    if not os.path.exists (srctar):
        print preambule + srctar + 'not exists'
        sys.exit(-1)
 
    if not os.path.exists (proxy):
        print preambule + 'First create the proxy'
        sys.exit(-1)
    pool = eval(decrypt('.cmtproxy')) 

#    for machine in pool:
#       host = pool[machine]['machine']
#       user = pool[machine]['user']
#       pwd = pool[machine] ['pwd']
       #print host, user, pwd, machine        

    # build the binaries
    print preambule + 'build the binaries'
    threads = []
#    pool = {
            # 'Linux-i686':pool['Linux-i686'], 
            # 'VisualC':pool['VisualC'] 
#            'CYGWIN_NT-5.1-i686':pool['CYGWIN_NT-5.1-i686']
#            }
    #pool = {'Linux-x86_64':pool['Linux-x86_64']}
    #pool = {'Darwin-PowerMacintosh':pool['Darwin-PowerMacintosh']}
    pool = {
           'CYGWIN_NT-5.1-i686':pool['CYGWIN_NT-5.1-i686'] ,
            'VisualC':pool['VisualC']
          } 
#     'OSF1-alpha':               'Linux-i686':              'Linux-x86_64':            'SunOS-sun4u': 'AIX-002064874C00':           
    # 'Darwin-PowerMacintosh' 'CYGWIN_NT-5.1-i686'       'VisualC'     

    for machine in pool:    
   #     print pool[machine]['machine'], pool[machine]['user'], pool[machine] ['pwd']
        cmd = "./cmt_build_binaries "+ version + " "+ machine
        print cmd
    #sys.exit(-1)            
    for machine in pool:    
       host = pool[machine]['machine']
       if host == '134.158.72.234' or host=='wl-72137.lal.in2p3.fr':
           host = '134.158.72.143'
           #host = '134.158.72.121'
            
       user = pool[machine]['user']
       pwd = pool[machine] ['pwd']
       print host, user, pwd, machine        
       thread = constructor( host=host, user=user, pwd=pwd, version=version, machine=machine)
       threads.append (thread)
       thread.run()
       #thread.start()

    #for thread in threads:
    #    thread.join ()
#----------------------- End Of File --------------------------#