#!/usr/bin/env python
#--------------------------------#
# Author: V.garonne              #
# Mail: garonne@lal.in2p3.fr     #
# Description: script to create  #
# automaticaly a release         #
#--------------------------------#

import pexpect
import sys, os
import string
import commands
import shutil
import socket
import tarfile, gzip

# my own stuffs
from utils.ssh_session import *

#lxbuild002.cern.ch

#--------------------# MAIN #-------------------------#
#if __name__ == '__main__':  
def cmt_create_srctar (svnroot, version):
    path      = 'tmp/CMT/'
    preambule = 'build_release > '
    here      =  os.getcwd()
    hostname  =  socket.gethostname()
    tarballs  =  list()
    
    # do a new fresh temp directory    
    if os.path.exists('tmp'):
        shutil.rmtree('tmp')
    os.makedirs (path)
    os.chdir    (path)
   
    cmd = 'svn export ' + svnroot + '/'+ version 
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    print output
    os.chdir(version)
    
    # fisrt remove .ps and .pdf
    files = ['doc/CMTDoc.ps', 'doc/CMTFAQ.ps', 'doc/CMTDoc.pdf','doc/CMTFAQ.pdf']
    for file in files:
        if os.path.exists(file):
            os.remove(file)
            
    # build the src tarball    
    namelist = ['source','mgr','src','Visual','java','doc']
    tar      = tarfile.open("../../../CMT"+version+".tar.gz", "w:gz")
    for name in namelist:
        print preambule + 'add the file ' + name + ' to the source archive'
        tar.add(name=name, arcname='CMT'+'/'+version+'/'+name)
    tar.close()
    tarballs.append ("CMT"+version+".tar.gz")
    os.chdir(here)
    shutil.rmtree ('tmp')

#----------------------- End Of File --------------------------#