#!/usr/bin/env python
#--------------------------------#
# Author: V.garonne              #
# Mail: garonne@lal.in2p3.fr     #
# Description: script to export  #
# a CMT release to the web site  #
#--------------------------------#

import sys, os
import string
import commands
import shutil
import socket
import tarfile, gzip
import threading

# my own stuffs
from utils.ssh_session import *
from p3                import decrypt

#--------------------# MAIN #-------------------------#
#if __name__ == '__main__':  
def cmt_export (svnroot, version, wwwroot):
    # variables
    proxy     = '.cmtproxy'
    preambule = 'cmt_export > '
    platforms = [
    'OSF1-alpha',
    'Linux-i686', 
    'Linux-x86_64',
    'Linux-ia64', 
    'SunOS-sun4u', 
    'AIX-002064874C00', 
    'Darwin-PowerMacintosh',
    'VisualC',
    'CYGWIN_NT-5.1-i686',
    ''
    ]
    
    if not os.path.exists (proxy):
        print preambule + 'First create the proxy'
        sys.exit(-1)
    pool    = eval(decrypt('.cmtproxy')) 
    machine = 'OSF1-alpha'
    host    = pool[machine]['machine']
    user    = pool[machine]['user']
    pwd     = pool[machine] ['pwd']
    session = ssh_session (user='garonne', host='lx.lal.in2p3.fr', password=pwd, verbose=1)
    
    file = 'CMT-'+version+'.pacman'
    print file
    content = '''#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

description ('CMT %s')
packageName ('CMT')
version ('%s')

pacmanVersionGE('3.13')

{
    platformGE ('Linux') ; downloadUntar ('http://www.cmtsite.org/%s/CMT%sLinux-i686.tar.gz', 'CMTBASE')
  OR 
    platformGE ('Cygwin') ; downloadUntar ('http://www.cmtsite.org/%s/CMT%sCYGWIN_NT-5.1-i686.tar.gz', 'CMTBASE')
  OR
    downloadUntar ('http://www.cmtsite.org/%s/CMT%s.tar.gz', 'CMTBASE')
}

cd ('$CMTBASE/%s/mgr')
shellOutputContains ('./INSTALL', 'CMT installation terminated')
{
  shellOutputContains ('. setup.sh; cmt version', '%s') 
    OR shell ('. setup.sh; gmake') 
}
shellOutputContains ('. setup.sh; cmt version', '%s')
cd ()'''%(version,version,version, version,version,version,version,version,version,version,version)
    
    f =open (file, 'w+')
    f.write (content)
    f.close()
    session.scp  (file,  wwwroot + '/pacman/cache/.')

    # Second pacman Cache
    path = '/afs/cern.ch/atlas/software/kits/CMT'
    url  = 'http://cern.ch/atlas-computing/links/kitsDirectory/CMT'
    content = '''#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

description ('CMT %s')
packageName ('CMT')
version ('%s')

pacmanVersionGE('3.13')

{
    platformGE ('Linux') ; downloadUntar ('http://cern.ch/atlas-computing/links/kitsDirectory/CMT/%s/CMT%sLinux-i686.tar.gz', 'CMTBASE')
  OR 
    platformGE ('Cygwin') ; downloadUntar ('http://cern.ch/atlas-computing/links/kitsDirectory/CMT/%s/CMT%sCYGWIN_NT-5.1-i686.tar.gz', 'CMTBASE')
  OR
    downloadUntar ('http://cern.ch/atlas-computing/links/kitsDirectory/CMT/%s/CMT%s.tar.gz', 'CMTBASE')
}

cd ('$CMTBASE/%s/mgr')
shellOutputContains ('./INSTALL', 'CMT installation terminated')
{
  shellOutputContains ('. setup.sh; cmt version', '%s') 
    OR shell ('. setup.sh; gmake') 
}
shellOutputContains ('. setup.sh; cmt version', '%s')
cd ()'''%(version,version,version, version,version,version,version,version,version,version,version)


    f =open (file, 'w+')
    f.write (content)
    f.close()
   
    machine = 'Linux-i686'
    host    = pool[machine]['machine']
    user    = pool[machine]['user']
    pwd     = pool[machine] ['pwd']
    session2 = ssh_session (user=user, host=host, password=pwd, verbose=1)
    session2.scp  (file, path + '/pacman/cache/.')    
    
    
    files =  [
    'doc/CMTDoc.html',
	'doc/CMTDoc.ps',
	'doc/CMTDoc.pdf',
	'doc/CMTFAQ.html',
	'doc/CMTDownload.html',
	'doc/ReleaseNotes.html',
	'doc/ChangeLog.html',
	'mgr/ChangeLog.php',
	'doc/CMTFAQ.ps',
	'doc/CMTFAQ.pdf'
             ]
             
    cmd = 'svn export '+ svnroot + version 
    print preambule + cmd
    status, output = commands.getstatusoutput (cmd)
    print output 
    
    #print  preambule + 'Build the documentations'
    #make doxygen, doxygen must be installed localy
    #cmd    =  'cd '+version+'/doc; rm -Rf Doxygen; doxygen'
    #print preambule + cmd 
    #status, output = commands.getstatusoutput (cmd)
    #print output
    #print session.scp  (version+'/doc/Doxygen',  wwwroot, 'r')   
    
    session.ssh ('mkdir -p '+ wwwroot +'/'+version)
    session2.ssh ('mkdir -p '+ path +'/'+version)
    for file in files:    
        print session.scp  (version+'/'+file,  wwwroot + '/.')    
        print session.scp  (version+'/'+file,  wwwroot + '/'+version + '/.')         
        
    for platform in platforms:
        file = 'CMT'+version+platform+'.tar.gz'    
        if os.path.exists(file):
            print file
            print session.scp   (file,  wwwroot + '/'+version+'/.')
            print session2.scp  (file,  path + '/'+version+'/.')
  
    cmd = 'svn co https://svn.lal.in2p3.fr:/projects/CMT/cmtsite'
    print preambule + cmd 
    status, output = commands.getstatusoutput (cmd)
    print output

    print '\t You should manually the old release number by '+ version +' in the cmtsite/download.html file ? (y/n)'
    choice ='y'
    choice    = raw_input('--> ')
    if choice!='y' and choice!='Y': sys.exit(-1)
    os.chdir('cmtsite')
    cmd = "svn commit -m 'update the version number for download.html'"
    print preambule + cmd 
    status, output = commands.getstatusoutput (cmd)
    print output
    os.chdir('..')
    session.scp  ('cmtsite/download.html',  wwwroot + '/.') 
  
    # Do the Clean up
    shutil.rmtree ('cmtsite')
    shutil.rmtree (version)
#----------------------- End Of File --------------------------#