#!/bin/sh

# cmt_lockfile.sh: Basic semaphore-file creator for Unix
# Use it if the lockfile utility from http://www.procmail.org/
# is not installed

if [ "$1" == "" ]; then
    echo "Usage: cmt_lockfile.sh file" >&2
    exit 1
else
    secs=8
    dir=`dirname $1`
    if [ ! -d $dir ]; then
	echo "Giving up on \"$1\"" >&2
	exit 1
    fi
    if fs examine -path $dir >/dev/null 2>&1; then
	fstype=afs
    fi
    while :; do
	[ "$fstype" == afs ] && fs flush -path $dir
	mkdir $1 2>/dev/null && break
	sleep $secs
    done
fi
