//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

//#include <stdio.h>
//#include <stdlib.h>
//#include <stdio.h>
//#include <string.h>
#include "cmt_std.h"
//#include "cmt_string.h"

#include "cmt_log.h"
#include "cmt.h"

CmtLog::CmtLog ()
{
}

CmtLogEnd& CmtLog::end ()
{
  static CmtLogEnd me;

  return (me);
}

bool CmtLog::check ()
{
  if (Cmt::get_debug ()) return (true);
  return (false);
}

CmtLog& CmtLog::operator << (const char* c)
{
  if (!check ()) return (*this);

  cout << c;
  return (*this);
}

CmtLog& CmtLog::operator << (const cmt_string& s)
{
  if (!check ()) return (*this);

  cout << s;
  return (*this);
}

CmtLog& CmtLog::operator << (int i)
{
  if (!check ()) return (*this);

  cout << i;
  return (*this);
}

CmtLog& CmtLog::operator << (double d)
{
  if (!check ()) return (*this);

  cout << d;
  return (*this);
}

CmtLog& CmtLog::operator << (void* p)
{
  if (!check ()) return (*this);

  cout << p;
  return (*this);
}

CmtLog& CmtLog::operator << (CmtLogEnd& end)
{
  if (!check ()) return (*this);

  cout << endl;
  return (*this);
}

CmtLog& CmtLog::operator << (CmtLogDummy& end)
{
  return (*this);
}
