#!/bin/sh

#---------------------------------------------------------------------
#
# This script should be installed within the commitinfo file of CVS
# using the following line :
#
# ...
#.cvsinfos $CVSROOT/CVSROOT/cmt_buildcvsinfos.sh
# ...
#
# and is used whenever one tries to import a file named cmt.cvsinfos
#
#  This file should only contain the name of a CVS module onto which
# queries are to be done.
# 
#---------------------------------------------------------------------

#set -x

echo $*

if test "$1" = "" ; then
  exit 1
fi

if test "$1" = "cmt.cvsinfos" ; then
  module=`cat $1`
elif test "$1" = "methods.cvsinfos" ; then
  module=`cat $1`
elif test "$2" = "cmt.cvsinfos" ; then
  module=`cat $2`
elif test "$2" = "methods.cvsinfos" ; then
  module=`cat $2`
else
  exit 1
fi

if test "${module}" = "" ; then
  exit 1
fi

if test -d ${CVSROOT}/${module} ; then
  if test -r ${CVSROOT}/${module}/mgr/requirements,v ; then
    test_file=${CVSROOT}/${module}/mgr/requirements,v
  else
    test_file=`find ${CVSROOT}/${module} -name '*,v' -print | head -n 1`
  fi

  tags=`tr ' ' '\n' < ${test_file} | \
   awk '/symbols/,/locks/ {n=split($0,w,"."); if ((n == 2) || (n == 4)) print; }'  | \
   sed -e 's#:.*##' -e 's#[ 	]*##'`
else
  echo # Module ${module} not found.
fi

branches=
for branch in `ls ${CVSROOT}/${module} | grep -v Attic` ; do
  if test -d ${CVSROOT}/${module}/${branch} ; then
    if test ! -r ${CVSROOT}/${module}/${branch}/cmt/requirements,v ; then
      if test ! -r ${CVSROOT}/${module}/${branch}/mgr/requirements,v ; then
	if test "${branches}" = "" ; then
	  branches="${branch}"
	else
	  branches="${branches} ${branch}"
	fi
      fi
    fi
  fi
done

subpackages=
for branch in `ls ${CVSROOT}/${module} | grep -v Attic` ; do
  if test -d ${CVSROOT}/${module}/${branch} ; then
    if test -r ${CVSROOT}/${module}/${branch}/cmt/requirements,v ; then
      if test "${subpackages}" = "" ; then
	subpackages="${branch}"
      else
	subpackages="${subpackages} ${branch}"
      fi
    elif test -r ${CVSROOT}/${module}/${branch}/mgr/requirements,v ; then
      if test "${subpackages}" = "" ; then
	subpackages="${branch}"
      else
	subpackages="${subpackages} ${branch}"
      fi
    fi
  fi
done

echo tags=${tags}
echo branches=${branches}
echo subpackages=${subpackages}

exit 1
