#!/bin/sh -f

#------------------------------------------------------------------------------
# Arguments:
#
# -source=1   absolute source directory
# -name=2     file name
# -out=3      absolute installation directory
# -cmd=4      installation system command
# -cmtpath=5  cmtpath of the package
#
#           OR
#
# -source 1   absolute source directory
# -name 2     file name
# -out 3      absolute installation directory
# -cmd 4      installation system command
# -cmtpath 5  cmtpath of the package
#
#           OR
#
# 1   absolute source directory
# 2   file name
# 3   absolute installation directory
# 4   installation system command
# 5   cmtpath of the package
#------------------------------------------------------------------------------
: ${CMTMSGPREFIX:=$0:}

source_dir=""
file_name=""
install_dir=""
install_command=""
cmtpath=""

#handle_args $*
#
#------------------------------------------------------------------------------
#handle_args ()
#{
  opt="-source"

  while test $# -gt 0; do
    arg=$1
    shift

    val=${arg}
    
    case ${arg} in
	-?*=*)
	    opt=${arg%%"="*}
	    val=${arg#"${opt}="}
	    ;;
	-?*)
	    opt=${arg}
	    val=
	    if test $# -gt 0; then
		val=$1
		shift
	    fi
	    ;;
    esac
    
    case ${opt} in
      -source)
	source_dir=${val};
	opt="-name";
	;;
      -name)
	file_name=${val};
	opt="-out";
	;;
      -out)
	install_dir=${val};
	opt="-cmd";
	;;
      -cmd)
	install_command=${val};
	opt="-cmtpath";
	;;
      -cmtpath)
	cmtpath=${val};
	opt="";
	;;
      *)
	;;
    esac
    
  done
    
  if test "${source_dir}" = ""; then
    echo "cmt_install_action.sh> no source directory"
    exit 1
  fi
    
  if test "${file_name}" = ""; then
    echo "cmt_install_action.sh> no file name"
    exit 1
  fi
    
  if test "${install_dir}" = ""; then
    echo "cmt_install_action.sh> no install dir"
    exit 1
  fi
    
  if test "${install_command}" = ""; then
    echo "cmt_install_action.sh> no install command"
    exit 1
  fi
    
  if test "${cmtpath}" = ""; then
    package=`cmt show macro_value package`
    cmtpath=`cmt show macro_value ${package}_cmtpath`
  fi

  if test ! -d "${cmtpath}"; then
    echo "cmt_install_action.sh> no cmtpath"
    exit 1
  fi
#}

dest_file_path=${install_dir}/${file_name}
ref_file=${dest_file_path}.cmtref
full_source_name=${source_dir}/${file_name}

case `pwd -P` in
    `(cd ${cmtpath}; pwd -P)`*) : ;;
    *) echo "Current directory outside of the installation area. Cannot proceed";
	exit 0 ;;
esac

if test ! -d ${install_dir}; then
    mkdir -p ${install_dir} ||
    { echo "Cannot install file ${file_name} into installation directory ${install_dir}"; exit 0; }
fi

if test -L ${dest_file_path} -o -f ${dest_file_path}; then
    /bin/rm -f ${dest_file_path}
fi

if test -f ${ref_file}; then
  /bin/rm -f ${ref_file}
fi

if test "${cmtmsg}"; then
echo "${CMTMSGPREFIX}" "installing file ${file_name} into ${install_dir}"
fi
if test "${makecmd}"; then set -v; fi
eval ${install_command} ${full_source_name} ${dest_file_path}
echo ${full_source_name} >${ref_file}
if test "${makecmd}"; then set +v; fi
