#!/bin/sh

export LC_ALL=C
#--------------------------------------------------
select_system ()
#--------------------------------------------------
{
  if test ! "${UNAME}" = "" ; then
    echo ${UNAME}
    return 0
  else
    UNAME=`uname`
  fi

  may_use_afs=1

  case ${UNAME} in
    Darwin)
      may_use_afs=0
      ;;
  esac

  if test "${may_use_afs}" = 1; then
    a=`fs sysname 2>/dev/null`
    if test $? = 0 ; then
      echo $a | \
        sed -e "s#[ :]##g" \
            -e "s#'# #g" \
            -e "s#Currentsysnameis##" \
            -e "s#Currentsysnamelistis##" | awk '{print $1}'
          
      return 0
    fi
  fi

  case ${UNAME} in
    LynxOS)
	    echo `uname`-`uname -m`
	    return 0
	    ;;
    Linux)
	   echo `uname`-`uname -m`
	   return 0
	   ;;
    Darwin)
	   echo `uname`
	   return 0
	   ;;
    CYGWIN*)
	   echo `uname`
	   return 0
	   ;;
    OSF1)
	  if test `uname -r` = "V3.2" ; then
	    echo alpha_v3
	    return 0
	  fi
	  ;;
    HP-UX)
	   if test `uname -m` = "9000/780" ; then
	     echo hp9000s780
	     return 0
	   elif test `uname -m` = "9000/735" ; then
	     echo hp9000s735
	     return 0
	   fi
	   ;;
  esac

  echo `uname -m`
  return 0
}

#--------------------------------------------------
# main ()
#--------------------------------------------------

select_system
