//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_string_h__
#define __cmt_string_h__

#include <stdio.h>
#include <string.h>

class cmt_string
{
public:
  typedef enum
    {
      npos = -1
    } pos_type;

    //
    // Constructors
    //
  cmt_string ();
  cmt_string (int n);
  cmt_string (char c);
  cmt_string (const char* text);
  cmt_string (const cmt_string& other);
  ~cmt_string ();

    //
    // Operators
    //
  cmt_string& operator = (char c);
  cmt_string& operator = (const char* text);
  cmt_string& operator = (const cmt_string& other);

  bool read (const cmt_string& file_name);
  bool write (const cmt_string& file_name) const;
  void write (FILE* f) const;
  void write (ostream& output);

  operator const char* () const;

  const char* c_str () const;
  /*char* c_str (); */

  void operator += (char c);
  void operator += (const char* text);
  void operator += (const cmt_string& other);

  cmt_string operator + (char c) const;
  cmt_string operator + (const char* text) const;
  cmt_string operator + (const cmt_string& other) const;

  char operator [] (int index) const;
  char& operator [] (int index);

  int size () const;
  int size ();
  void resize (int n);

  int find (char c) const;
  int find (const char* text) const;
  int find (const cmt_string& other) const;
  int find (int pos, char c) const;
  int find (int pos, const char* text) const;
  int find (int pos, const cmt_string& other) const;

  int find_last_of (char c) const;
  int find_last_of (const char* text) const;
  int find_last_of (const cmt_string& other) const;

  void erase (int pos);
  void erase (int pos, int length);

  void replace (const char* pattern, const char* replacement);
  void replace (const cmt_string& pattern, const cmt_string& replacement);

  void replace_all (const char* pattern, const char* replacement);
  void replace_all (const cmt_string& pattern, const cmt_string& replacement);

  void trim ();

  cmt_string substr (int pos) const;
  cmt_string substr (int pos, int length) const;

  void substr (int pos, cmt_string& dest) const;
  void substr (int pos, int length, cmt_string& dest) const;

  bool operator < (const char* text) const;
  bool operator < (const cmt_string& other) const;

  bool operator == (const char* text) const;
  bool operator == (const cmt_string& other) const;

  bool compare_no_case (const char* text) const;
  bool compare_no_case (const cmt_string& other) const;

  bool operator != (const char* text) const;
  bool operator != (const cmt_string& other) const;

  bool operator > (const char* text) const;
  bool operator > (const cmt_string& other) const;

private:
  void extend (int n);
  void allocate (int n);

  char* _data;
  int _allocated;
  int _size;
};

ostream& operator << (ostream& o, const cmt_string& s);
cmt_string operator + (const char* text, const cmt_string& s);
cmt_string operator + (char c, const cmt_string& s);

#endif
