//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// Modified by garonne@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_error_h__
#define __cmt_error_h__

#include "cmt_std.h"
#include "cmt_string.h"

class CmtError
{
public:

  typedef enum
  {
    ok,
    warning,
    symbol_not_found,
    pattern_not_found,
    constituent_not_found,
    fragment_not_found,
    language_not_found,
    syntax_error,
    command_not_implemented,
    package_not_found,
    path_not_found,
    version_conflict,
    file_access_error,
    configuration_error,
    execution_error,
    cannot_lock,
    cannot_write_lock,
    cannot_run_lock_command,
    cannot_unlock,
    cannot_run_unlock_command,
    cannot_remove_lock,
    conflicting_lock,
    unknown_command,    
    project_release_conflict,
    execution_failed
  } code;
 
  
  static void clear ();
  static code get_last_error_code ();
  static bool has_pending_error ();
  static const cmt_string& get_error_name (code error);
  static void set (code error, const cmt_string& text, const int execution_error=0);

  static int get_last_execution_error ();

  static cmt_string get_last_error ();
  static void print ();
    
};

#endif
