//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_vcs_h__
#define __cmt_vcs_h__

#include "cmt_system.h"

class Vcs
{
 public:

  typedef enum
    {
      Cvs,
      Svn
    } VcsType;

 public:
  
/*   static void tags (const CmtSystem::cmt_string_vector& arguments); */
/*   static void branches (const cmt_string& module); */
/*   static void subpackages (const cmt_string& module); */
/*   static void subprojects (const cmt_string& module); */
  static void checkout (const CmtSystem::cmt_string_vector& arguments);

  class Checkout
  {
  public:
    Checkout ()
      : m_recursive (false), m_context (false)
      { }
    cmt_string m_version_tag;
    cmt_string m_checkout_dir;
    cmt_string m_version_dir;
    cmt_string m_offset;
    CmtSystem::cmt_string_vector m_modules;
    cmt_string m_requirements;
    cmt_string m_command;
    bool m_recursive;
    bool m_context;
    void print ()
      {
	cerr << "m_version_tag: " << m_version_tag << endl;
	cerr << "m_checkout_dir: " << m_checkout_dir << endl;
	cerr << "m_version_dir: " << m_version_dir << endl;
	cerr << "m_offset: " << m_offset << endl;
	for (int arg = 0; arg < m_modules.size (); arg++)
	  {
	    cerr << "m_modules[" << arg << "]: " << m_modules[arg] << endl;
	  }
	cerr << "m_requirements: " << m_requirements << endl;
	cerr << "m_command: " << m_command << endl;
	cerr << "m_recursive: " << m_recursive << endl;
	cerr << "m_context: " << m_context << endl;
      }
  };

  static void checkout_module (const Checkout& checkout,
			       bool config, bool with_version_directory,
			       const cmt_string& module, cmt_string version_tag,
			       VcsType type);
  static void checkout_from_requirements (const Checkout& checkout,
					  bool config, bool with_version_directory,
					  const cmt_string& requirements,
					  VcsType type);

 private:

  static void help ();
  static void add_cmtpath (const cmt_string& dir);
  static bool need_version_directory ();
  static int parse_checkout (const CmtSystem::cmt_string_vector& arguments,
			     Checkout& checkout, bool& config);
};

class Svn
{
 public:
  
  static void checkout (Vcs::Checkout checkout,
		       bool config, bool with_version_directory);
};

#endif
