//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_vcs_h__
#define __cmt_vcs_h__

#include "cmt_system.h"
#include "cmt_use.h"

class Modules;
class Vcs
{
 public:

  typedef enum
    {
      Cvs,
      Svn
    } VcsType;

 public:
  
/*   static void tags (const CmtSystem::cmt_string_vector& arguments); */
/*   static void branches (const cmt_string& module); */
/*   static void subpackages (const cmt_string& module); */
/*   static void subprojects (const cmt_string& module); */
  static void checkout (const CmtSystem::cmt_string_vector& arguments);

  class Checkout
  {
  public:
    Checkout ()
      : m_head (false), m_recursive (false), m_context (false), m_info (false)
      { }
    cmt_string m_version_tag;
    bool m_head;
    cmt_string m_checkout_dir;
    cmt_string m_version_dir;
    cmt_string m_offset;
    CmtSystem::cmt_string_vector m_modules;
    cmt_string m_requirements;
    cmt_string m_command;
    bool m_recursive;
    bool m_context;
    bool m_info;
    void print ()
      {
	cerr << "m_version_tag: " << m_version_tag << endl;
	cerr << "m_head: " << m_head << endl;
	cerr << "m_checkout_dir: " << m_checkout_dir << endl;
	cerr << "m_version_dir: " << m_version_dir << endl;
	cerr << "m_offset: " << m_offset << endl;
	for (int arg = 0; arg < m_modules.size (); arg++)
	  {
	    cerr << "m_modules[" << arg << "]: " << m_modules[arg] << endl;
	  }
	cerr << "m_requirements: " << m_requirements << endl;
	cerr << "m_command: " << m_command << endl;
	cerr << "m_recursive: " << m_recursive << endl;
	cerr << "m_context: " << m_context << endl;
      }
  };

  static void checkout_module (const Checkout& checkout,
			       bool config, bool with_version_directory,
			       cmt_string module, cmt_string version_tag,
			       VcsType type);
  static void checkout_from_requirements (const Checkout& checkout,
					  bool config, bool with_version_directory,
					  const cmt_string& requirements,
					  VcsType type);
  static void checkout_context (const Checkout& checkout, Modules modules,
				bool config, bool with_version_directory,
				VcsType type);

 private:

  static void help ();
  static void add_cmtpath (const cmt_string& dir);
  static bool need_version_directory ();
  static int parse_arguments (const CmtSystem::cmt_string_vector& arguments,
			      Checkout& checkout, bool& config);
  static int parse_checkout (Checkout& checkout, Modules& modules);
  //  static int parse_checkout (const Checkout& checkout, cmt_string& uses);
  static int resolve_uses (const cmt_string& text, cmt_string& uses);
  static int resolve_uses (const cmt_string& text, Use::UsePtrVector& uses);
  static int resolve_uses (const Checkout& checkout, const cmt_string& uses);
  //  static int resolve_uses (const Checkout& checkout, const Modules& modules);
  //  static void start_visit (IUseVisitor& visitor);
};

class Svn
{
 public:
  
  static void checkout (Vcs::Checkout checkout, Modules modules,
		       bool config, bool with_version_directory);
};

class IUseVisitor
{
 public:
  //virtual void pre (Project* p) = 0;
  virtual void in (Use* use) = 0;
  //virtual void in_again (Project* p) = 0;
  //virtual void post (Project* p) = 0;
};

#endif
