//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_cmtpath_pattern_h__
#define __cmt_cmtpath_pattern_h__

#include "cmt_pattern.h"

class CmtPathPattern
{
public:
  typedef cmt_vector<CmtPathPattern> CmtPathPatternVector;
  typedef cmt_vector<CmtPathPattern*> CmtPathPatternPtrVector;

  static void action (const CmtSystem::cmt_string_vector& words, Use* use, bool revert = false);

  static void add (const CmtSystem::cmt_string_vector& words, Use* use, bool revert);

  static int pattern_number ();
  static CmtPathPattern& pattern (int index);
  static void clear_all ();
  static CmtPathPatternVector& patterns ();

  static void apply_all ();
  static void show_all ();

public:
  CmtPathPattern ();
  ~CmtPathPattern ();

  void clear ();
  void apply () const;
  void expand (cmt_string& line, const cmt_string& path, const cmt_string& project) const;

  cmt_string line;
  Use* use;
  bool revert;
};

#endif
