//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// Modified by garonne@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_commands_h__
#define __cmt_commands_h__

#include "cmt_map.h"
#include "cmt.h"

class ArgParser
{
public:
  typedef void (ArgParser::* parser) (void);

  ArgParser (CmtContext& context);

  void parse ();

  int argc;
  char** argv;
  cmt_string arg;
  CmtSystem::cmt_string_vector arguments;
  cmt_string extra_line;
  cmt_string extra_file;
  PrintMode mode;
  ActionType help_action;

private:
  void do_awk ();
  void do_broadcast ();
  void do_build ();
  void do_check ();
  void do_check_files ();
  void do_checkout ();
  void do_cleanup ();
  void do_config ();
  void do_create ();
  void do_create_project ();
  void do_cvsbranches ();
  void do_cvssubpackages ();
  void do_cvssubprojects ();
  void do_cvstags  ();
  void do_do       ();
  void do_expand   ();
  void do_filter   ();
  void do_help     ();
  void do_lock     ();
  void do_relocate ();
  void do_remove   ();
  void do_run      ();
  void do_run_sequence ();
  void do_set ();
  void do_setup ();
  void do_show ();
  void do_system ();
  void do_unlock ();
  void do_version ();
  void option_disable_warnings();
  void option_help ();
  void option_n ();
  void option_quiet ();
  void option_warnings ();
  void option_csh ();
  void option_sh ();
  void option_bat ();
  void option_requirements ();
  void option_use ();
  void option_pack ();
  void option_version ();
  void option_path ();
  void option_f ();
  void option_e ();
  void option_home ();
  void option_tag ();
  void option_tag_add ();
  void option_tag_remove ();
  void option_user_context ();
  void option_with_version_directory ();
  void option_without_version_directory ();
  void option_no_cleanup ();
  void option_private ();
  void option_public ();

  void shift ();
  void unshift ();
  void fill_arguments ();
  cmt_string& fill_one_argument ();
  cmt_string& fill_one_argument_filtered ();

  CmtContext& cmt;

  cmt_vmap <cmt_string, int> parsers;
  cmt_vector <parser> pv;

};

class CommandHelp
{
public:
  typedef cmt_map <ActionType, cmt_string> HelpMap;
  typedef cmt_vector <cmt_string> HelpTexts;

  static HelpMap& get_help ();
  static HelpTexts& get_help_texts ();
  static const cmt_string& get_help_text (ActionType key);
  static void show_all ();
  static void show (ActionType action);

private:
  static CommandHelp& instance ();

  CommandHelp ();

  HelpMap m_help;
  HelpTexts m_help_texts;
};

#endif
