#! /bin/bash

function help ()
{
  echo "Usage: `basename $0` [OPTION]... [PACKAGE]..."
  echo -e "Create a distribution kit of the PACKAGEs (all by default) reachable from the \"main\" package (TestRelease by default) in a user's devarea (defaults to either the environment variable, macro devarea in \${HOME}/cmthome/requirements, first entry in CMTPATH, or \${HOME}/MyTest).\n"
  echo "  -a <dev_area> : select development area <dev_area>"
  echo "  -m <main_pkg> : select \"main\" package <main_pkg> in development area"
  echo "  -r <release>  : select Atlas release <release>"
  echo "  -d <kit_dir>  : create kit in directory <kit_dir>"
  echo "  -O            : package optimized build (debug otherwise)"
  echo "  -S            : skip CMT setup"
  echo -e "  -h            : display this help and exit\n"
  echo "Report bugs to <Grigori.Rybkine@rhul.ac.uk>."
}

#
# Process the options and arguments
#
release=${ATLAS_RELEASE}
mode=
packages=
devarea=${devarea}
mainpkg=TestRelease
skip=

while getopts ":a:m:r:d:OSh" opt; do
  case $opt in
    a ) devarea=${OPTARG} ;;
    m ) mainpkg=${OPTARG} ;;
    r ) release=${OPTARG} ;;
    d ) PACMAN_CACHE=${OPTARG} ;;
    O ) mode=opt ;;
    S ) skip=true ;;
    h ) help ; exit 0 ;;
    \?|: ) help ; exit 1 ;;
  esac
done

shift $(($OPTIND - 1))

for pkg ; do
  package=`echo ${pkg} | sed -e 's#^[^/]#/&#' -e 's#[^/]$#&/#'`
  packages="${packages} ${package}"
done

shift $#

#
# Locate the Deployment package
#
curdir=$PWD
cd `dirname $0`
dep=$PWD

#
# Connect to the release
#
if [ -z ${skip} ] ; then

cd ${HOME}/cmthome || exit
if [ "${release}" ] && [ "${mode}" ] ; then
  source setup.sh -tag=${release},${mode}
  if [ -z "${devarea}" ] ; then
    devarea=`cmt show macro_value devarea -tag=${release},${mode}`
  fi
elif [ "${release}" ] && [ -z "${mode}" ] ; then
  source setup.sh -tag=${release}
#  mode=`cmt system | sed 's/.*\-//g'`
  [ "${devarea}" ] || devarea=`cmt show macro_value devarea -tag=${release}`
elif [ -z "${release}" ] && [ "${mode}" ] ; then
  source setup.sh -tag=${mode}
  release=`cmt show macro_value ATLAS_RELEASE -tag=${mode}`
  [ "${devarea}" ] || devarea=`cmt show macro_value devarea -tag=${mode}`
else
  source setup.sh
  release=`cmt show macro_value ATLAS_RELEASE`
#  mode=`cmt system | sed 's/.*\-//g'`
  [ "${devarea}" ] || devarea=`cmt show macro_value devarea`
fi

else
  which cmt > /dev/null 2>&1 || { echo "CMT not setup" ; exit 1; }
fi

[ "${release}" ] || { echo "Select Atlas release, please" ; exit 1; }

cmt_path_purge=`echo $CMTPATH | sed s/^:*//`
cmt_path_0=`echo ${cmt_path_purge} | cut -d: -f1`

if [ "${devarea}" ] ; then
  if echo ${devarea} | grep -vq ^/ ; then
    devarea=${curdir}/${devarea}
  fi
  devarea=`echo ${devarea} | sed 's#/*$##'`
  [ "${devarea}" != "${cmt_path_0}" ] && export CMTPATH=${devarea}:${CMTPATH}
else
# devarea specified through neither the option, environment nor macro
  devarea=${cmt_path_0}
  if [ -z "${devarea}" ] ; then
    devarea=${HOME}/MyTest ; export CMTPATH=${devarea}:${CMTPATH}
  fi
  echo "Using ${devarea} as devarea" 
fi

if [ "${mode}" ]; then
  mode_opt="-platform ${mode}"
else
  mode_opt=
fi

if [ "${PACMAN_CACHE}" ]; then 
  if echo ${PACMAN_CACHE} | grep -vq ^/ ; then
    PACMAN_CACHE=${curdir}/${PACMAN_CACHE}
  fi
else
  PACMAN_CACHE=/tmp/${LOGNAME}/${release}
  echo "Creating kit in ${PACMAN_CACHE}" 
fi

export PACMAN_CACHE
mkdir -p ${PACMAN_CACHE}

#
# Select the top location from which the construction kit will be broadcast
#
cd ${devarea}/${mainpkg}/${mainpkg}*/cmt || exit

#
# Set up the release context
#
source setup.sh -no_cleanup

#
# Connect to the patch directory
#
patches=/afs/cern.ch/user/a/alibrari/Kit/patches
patches_opt="-patches ${patches}"

#
# May need to construct the cycles file
#
if [ -r ${patches}/cycles_${release}.txt ] ; then
  cycles_opt="-cycles ${patches}/cycles_${release}.txt"
else
  cmt -quiet show cycles >| ${PACMAN_CACHE}/cycles_${release}.txt
  cycles_opt="-cycles ${PACMAN_CACHE}/cycles_${release}.txt"
fi

#
# Run the construction kit
#
if [ -z "${packages}" ] ; then
  ${dep}/create_project_kits.sh ${mode_opt}
  cmt broadcast -local ${dep}/create_kit.sh ${patches_opt} ${cycles_opt} ${mode_opt} ${PACMAN_CACHE}
else
  cmt broadcast -local -select="${packages}" ${dep}/create_kit.sh ${patches_opt} ${cycles_opt} ${mode_opt} ${PACMAN_CACHE}
  #cmt -quiet broadcast -local -select="${packages}" ${dep}/create_kit.sh ${patches_opt} ${cycles_opt} ${mode_opt} ${PACMAN_CACHE}
fi

cd $curdir

