//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "cmt_group.h"
#include "cmt_database.h"

/*----------------------------------------------------------*/
/*                                                          */
/*  Operations on Groups                                    */
/*                                                          */
/*----------------------------------------------------------*/

//----------------------------------------------------------
Group* Group::find (const cmt_string& name)
  //----------------------------------------------------------
{
  static GroupVector& Groups = groups ();

  for (int i = 0; i < Groups.size (); i++)
    {
      Group& v = Groups[i];

      if (v.m_name == name) return (&v);
    }

  return (0);
}

//----------------------------------------------------------
Group* Group::add (const cmt_string& name)
  //----------------------------------------------------------
{
  static GroupVector& Groups = groups ();

  {
    Group* group;

    group = find (name);
    if (group != 0) return (group);
  }

  Group& group = Groups.add ();
  group.set (name);

  return (&group);
}

//----------------------------------------------------------
Group::GroupVector& Group::groups ()
  //----------------------------------------------------------
{
  static Database& db = Database::instance ();
  static GroupVector& Groups = db.groups ();

  return (Groups);
}

/*----------------------------------------------------------*/
void Group::clear_all ()
  /*----------------------------------------------------------*/
{
  static GroupVector& Groups = groups ();

  for (int i = 0; i < Groups.size (); i++)
    {
      Group& group = Groups[i];
      group.clear ();
    }

  Groups.clear ();
}

/*----------------------------------------------------------*/
void Group::show_all ()
  /*----------------------------------------------------------*/
{
  static GroupVector& Groups = groups ();

  for (int i = 0; i < Groups.size (); i++)
    {
      Group& group = Groups[i];
      cout << group.m_name << endl;
    }
}

//----------------------------------------------------------
Group::Group ()
  //----------------------------------------------------------
{
}

//----------------------------------------------------------
Group::Group (const cmt_string& name) : m_name (name)
  //----------------------------------------------------------
{
}

//----------------------------------------------------------
const cmt_string& Group::name () const
  //----------------------------------------------------------
{
  return (m_name);
}

//----------------------------------------------------------
void Group::set (const cmt_string& name)
  //----------------------------------------------------------
{
  m_name = name;
}

//----------------------------------------------------------
void Group::clear ()
  //----------------------------------------------------------
{
  m_name = "";
}

//----------------------------------------------------------
Group& Group::operator = (const Group& other)
  //----------------------------------------------------------
{
  m_name = other.m_name;

  return (*this);
}

//----------------------------------------------------------
bool Group::operator == (const cmt_string& name) const
  //----------------------------------------------------------
{
  return ((m_name == name));
}

//----------------------------------------------------------
bool Group::operator != (const cmt_string& name) const
  //----------------------------------------------------------
{
  return ((m_name != name));
}

