//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_regexp_h__
#define __cmt_regexp_h__

#include "cmt_string.h"

class cmt_regexp_node;

class cmt_regexp
{
public:
  cmt_regexp ();
  cmt_regexp (const cmt_string& expression);
  ~cmt_regexp ();
  void clear ();

  void set (const cmt_string& expression);

  bool is_valid () const;
  
  class iterator
  {
public:
    static const iterator null ();
    
public:
    iterator ();
    iterator (int pos, int length);
    iterator (const iterator& other);
    
    int operator != (const iterator& other) const;
    int operator == (const iterator& other) const;
    int operator < (const iterator& other) const;

    cmt_string operator () (const cmt_string& text) const;
    
    int _pos;
    int _length;
  };
  
  iterator begin (const cmt_string& text, int pos = 0);
  iterator end ();
  
  iterator begin (const cmt_string& text, int pos = 0) const;
  iterator end () const;

  bool match (const cmt_string& text) const;
  
private:
  
  cmt_regexp_node* _root;
};

#endif

