#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

setenv CMTBIN `uname`-`uname -m | sed -e 's# ##g'`

if ( $?CMTCONFIG == 0 ) then
  setenv CMTCONFIG `${CMTROOT}/mgr/cmt_system.sh`
endif

if ( $?0 == 0 ) then
if ( $?tcsh == 1 || `basename "$shell"` == "tcsh" ) then
  source ${CMTROOT}/src/setup.tcsh
endif
endif

set newpath=

foreach p ( `echo ${PATH} | sed 's#:# #g'` )
  echo ${p} | egrep '/CMT/' >& /dev/null
  set s=${status}
  if ( "${s}" != 0 ) then
    if ( ${newpath} == "" ) then
      set newpath=${p}
    else
      set newpath=${newpath}:${p}
    endif
  endif
end

setenv PATH ${newpath}:"${CMTROOT}/${CMTBIN}"
alias cmt '${CMTROOT}/${CMTBIN}/cmt.exe'

if ( $?CLASSPATH == 0) then
  setenv CLASSPATH ${CMTROOT}/java
else
  set newpath=
  foreach p ( `echo ${CLASSPATH} | sed 's#:# #g'` )
    echo ${p} | egrep '/CMT/' >& /dev/null
    set s=${status}
    if ( "${s}" != 0 ) then
      if ( ${newpath} == "" ) then
        set newpath=${p}
      else
        set newpath=${newpath}:${p}
      endif
    endif
  end

  setenv CLASSPATH ${newpath}:${CMTROOT}/java/cmt.jar
endif

alias jcmt '(java cmt_parser)'
