#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

CMTBIN=`uname`-`uname -m | sed -e 's# ##g'`; export CMTBIN

if test "${CMTCONFIG}" = "" ; then
  CMTCONFIG=`${CMTROOT}/mgr/cmt_system.sh`; export CMTCONFIG
fi

if [ `expr $- : '.*i'` -ne 0 ]; then
if [ -n "${ZSH_NAME-}" ]; then
  . ${CMTROOT}/src/setup.zsh
elif [ -n "${BASH-}" ]; then
  . ${CMTROOT}/src/setup.bash
fi
fi

newpath=""
for p in `echo ${PATH} | sed 's/:/ /g'`; do
  if ! echo ${p} | egrep /CMT/ >/dev/null ; then
    if test "${newpath}" = "" ; then
      newpath=${p}
    else
      newpath=${newpath}:${p}
    fi
  fi
done

PATH=${newpath}:${CMTROOT}/${CMTBIN}; export PATH
alias cmt='${CMTROOT}/${CMTBIN}/cmt.exe'; export cmt

newpath=""
for p in `echo ${CLASSPATH} | sed 's/:/ /g'`; do
  if ! echo ${p} | egrep /CMT/ >/dev/null ; then
    if test "${newpath}" = "" ; then
      newpath=${p}
    else
      newpath=${newpath}:${p}
    fi
  fi
done

CLASSPATH=${newpath}:${CMTROOT}/java/cmt.jar; export CLASSPATH

alias jcmt='(java cmt_parser)'; export jcmt
