#!/bin/sh -f

#------------------------------------------------------------------------------
# Arguments:
#
# -source=1   absolute source directory
# -name=2     file name
# -out=3      absolute installation directory
# -cmtpath=4  cmtpath of the package
#
#           OR
#
# -source 1   absolute source directory
# -name 2     file name
# -out 3      absolute installation directory
# -cmtpath 4  cmtpath of the package
#
#           OR
#
# 1   absolute source directory
# 2   file name
# 3   absolute installation directory
# 4   cmtpath of the package
#------------------------------------------------------------------------------
: ${CMTMSGPREFIX:=$0:}

source_dir=""
file_name=""
install_dir=""
cmtpath=""

#handle_args $*
#
#------------------------------------------------------------------------------
#handle_args ()
#{
  opt="-source"

  while test $# -gt 0; do
    arg=$1
    shift

    val=${arg}
    
    case ${arg} in
	-?*=*)
	    opt=${arg%%"="*}
	    val=${arg#"${opt}="}
	    ;;
	-?*)
	    opt=${arg}
	    val=
	    if test $# -gt 0; then
		val=$1
		shift
	    fi
	    ;;
    esac
    
    case ${opt} in
      -source)
	source_dir=${val};
	opt="-name";
	;;
      -name)
	file_name=${val};
	opt="-out";
	;;
      -out)
	install_dir=${val};
	opt="-cmtpath";
	;;
      -cmtpath)
	cmtpath=${val};
	opt="";
	;;
      *)
	;;
    esac
    
  done
    
  if test "${source_dir}" = ""; then
    echo "cmt_uninstall_action.sh> no source directory"
    exit 1
  fi
    
  if test "${file_name}" = ""; then
    echo "cmt_uninstall_action.sh> no file name"
    exit 1
  fi
    
  if test "${install_dir}" = ""; then
    echo "cmt_uninstall_action.sh> no install dir"
    exit 1
  fi

  if test "${cmtpath}" = ""; then
    if [ -n "${CMTDEBUG:-}" ]; then
      unset CMTDEBUG
      set -x
    fi
    package=`cmt show macro_value package` || exit
    cmtpath=`cmt show macro_value ${package}_cmtpath` || exit
  fi

  if test ! -d "${cmtpath}"; then
    echo "cmt_uninstall_action.sh> no cmtpath"
    exit 1
  fi
#}

dest_file_path=${install_dir}/${file_name}
ref_file=${dest_file_path}.cmtref
full_source_name=${source_dir}/${file_name}

case `pwd -P` in
    `(cd ${cmtpath}; pwd -P)`*) : ;;
    *) echo "Current directory outside of the installation area. Cannot proceed";
	exit 0 ;;
esac

if test ! -d ${install_dir}; then
  echo "Cannot uninstall file ${file_name} from installation directory ${install_dir}"
  exit 0
fi

if test -L ${dest_file_path}; then

if test "${cmtmsg}"; then
  echo "${CMTMSGPREFIX}" removing symbolic link ${file_name} from ${install_dir}
fi
if test "${makecmd}"; then set -v; fi
  /bin/rm -f ${dest_file_path} || exit
if test "${makecmd}"; then set +v; fi

elif test -d ${dest_file_path}; then

if test "${cmtmsg}"; then
  echo "${CMTMSGPREFIX}" removing directory ${file_name} from ${install_dir}
fi
if test "${makecmd}"; then set -v; fi
  /bin/rm -rf ${dest_file_path} || exit
if test "${makecmd}"; then set +v; fi

elif test -f ${dest_file_path}; then

if test "${cmtmsg}"; then
  echo "${CMTMSGPREFIX}" removing file ${file_name} from ${install_dir}
fi
if test "${makecmd}"; then set -v; fi
  /bin/rm -f ${dest_file_path} || exit
if test "${makecmd}"; then set +v; fi

fi

if test -f ${ref_file}; then
if test "${makecmd}"; then set -v; fi
  /bin/rm -f ${ref_file} || exit
if test "${makecmd}"; then set +v; fi
fi
