cppcomp   = $(CXX) -c -I$(inc) $(CXXFLAGS) $(CPPFLAGS) $(TARGET_ARCH)
CXX = $(cpp)
CXXFLAGS = $(cppflags)
CPPFLAGS = $(pp_cppflags)

cpplink = $(CXX) $(CXXFLAGS) $(CPPFLAGS) $(LDFLAGS) $(TARGET_ARCH)
LDFLAGS = $(cpplinkflags)

ifeq ($(STATIC),1)
    cpplinkflags   += -static
endif

# in Makefile.core without -O2
cpp = g++ -O2

ifeq ($(CMTBIN),LinuxDebug)
cpp = g++ -g
endif

ifeq ($(CMTBIN),Linux-i686Debug)
cpp = g++ -g
endif

ifeq ($(CMTBIN),LinuxProf)
cpp = g++ -g -pg
endif

ifeq ($(CMTBIN),Linux-i686Prof)
cpp = g++ -g -pg
endif


ifeq ($(CMTBIN),LinuxInsure)
cpp = insure -g
endif

ifeq ($(CMTBIN),OSF1DEB)
cpp           = cxx -g3 -pg
endif

ifeq ($(CMTBIN),OSF1-alpha)
cpp           = cxx
endif

ifeq ($(CMTBIN),SunOS-sun4u)
cpp       = CC
endif

ifeq ($(CMTBIN),HP-UX)
cpp       = aCC
endif

ifneq (,$(findstring Darwin,$(CMTBIN)))
cpp       = c++ -O2
endif

#ifeq ($(CMTBIN),OSF1)
#remote_launch = rsh
#else
remote_launch = ssh
#endif

ifeq ($(CMTBIN),CYGWIN_NT-5.1-i686)
cpp = g++ -O2 -Wno-deprecated
cpp = g++ -g -Wno-deprecated
endif

ifeq ($(CMTBIN),LynxOS-PowerPC)
cpp = g++
endif

ifeq ($(CMTBIN),AIX-002065204C00)
cpp = g++ -O2 -Wno-deprecated
endif

#
# Derive mode/architecture from CMTBIN
#
ifneq (,$(findstring i386,$(CMTBIN)))
_mode = 32
endif
ifneq (,$(findstring i486,$(CMTBIN)))
_mode = 32
endif
ifneq (,$(findstring i586,$(CMTBIN)))
_mode = 32
endif
ifneq (,$(findstring i686,$(CMTBIN)))
_mode = 32
endif
ifneq (,$(findstring x86_64,$(CMTBIN)))
_mode = 64
endif

#
# Use mode/architecture specified on command line explicitly
#
ifeq ($(M32),1)
_mode = 32
endif
ifeq ($(M64),1)
_mode = 64
endif

#
# Specify mode explicitly for g++
# (on Mac OS X 10.6, uname -m may show i386
# while g++ builds for x86_64 by default)
#
ifneq (,$(findstring g++,$(cpp)))
ifeq ($(_mode),32)
    TARGET_ARCH = -m32
endif
ifeq ($(_mode),64)
    TARGET_ARCH = -m64
endif
endif

#
# Specify mode explicitly for Darwin
# (on Mac OS X 10.6, uname -m may show i386
# while c++ builds for x86_64 by default)
#
ifneq (,$(findstring Darwin,$(CMTBIN)))
ifeq ($(_mode),32)
    TARGET_ARCH = -arch i386
endif
ifeq ($(_mode),64)
    TARGET_ARCH = -arch x86_64
endif
endif

src       = ../src/
inc       = ../src/
mgr       = ../mgr/
# in Makefile.core
# bin       = ../$(tag)/
bin       = ../$(CMTBIN)/
binshort  = ../$(CMTBIN)

#cpp_silent =
#cpp_echo = @--->
#link_silent =
#link_echo = @--->

#SHELL     = /bin/sh

#tag       = 

# CMT requirements
application_suffix = .exe
#cmtexe    = $(CMTROOT)/$(CMTBIN)/cmt.exe
build_dependencies = $(cmtexe) -tag=$(tags) build dependencies

ifndef CMTDEPENDENCIES
ifneq (,$(findstring g++,$(cpp)))
cppdepflags = -MM
format_dependencies = $(CMTROOT)/mgr/cmt_format_deps.sh
build_dependencies = :
endif
ifneq (,$(findstring Darwin,$(CMTBIN)))
cppdepflags = -MM
format_dependencies = $(CMTROOT)/mgr/cmt_format_deps.sh
build_dependencies = :
endif
endif

use_requirements = requirements
includes = $(inc)
cmt_dependencies_in_cmt = /dev/null

ifndef SILENT
ifndef ECHO
ifndef QUIET
ifndef VERBOSE
# default settings to build CMT
#   o do not print CMT messages
#   o echo Make commands
cmtmsg =
makecmd = 1
echo = @:
silent =
MAKEFLAGS = --no-print-directory
endif
endif
endif
endif

CFLAGS = 
PACKAGE_ROOT = $(CMTROOT)
CMTINSTALLAREA = 
